package com.tacz.guns.client.gui.components;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.client.gui.GunSmithTableScreen;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.PackInfo;
import java.util.*;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_339;
import net.minecraft.class_342;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_4265;
import net.minecraft.class_6379;
import net.minecraft.class_6381;
import net.minecraft.class_6382;

public class GunPackList extends class_4265<GunPackList.Entry> {
    private final GunSmithTableScreen parent;
    private final List<Checkbox> gunPackList = new ArrayList<>();
    private final Set<String> selectedNamespaces = new HashSet<>();
    private final Checkbox byHandCheckbox;
    private final class_342 byName;

    /*@Override
    protected void renderListBackground(GuiGraphics pGuiGraphics) {
        super.renderListBackground(pGuiGraphics);
    }*/

    public GunPackList(class_310 pMinecraft, int pWidth, int pHeight, int pY0, int pY1, int pItemHeight,
                       Map<class_2960, List<class_2960>> recipes, GunSmithTableScreen parent) {
        super(pMinecraft, pWidth, pHeight, pY0, pItemHeight);
        this.parent = parent;
        Set<String> namespaces = new HashSet<>();
        for (List<class_2960> entry : recipes.values()) {
            entry.forEach((resourceLocation) -> namespaces.add(resourceLocation.method_12836()));
        }

        this.byName = new class_342(pMinecraft.field_1772, 3, 0, 94, 10, class_2561.method_43473());
        this.byName.method_47404(class_2561.method_43471("gui.tacz.gun_smith_table.filter.search"));
        this.byName.method_1863((pText) -> {
            parent.method_25426();
            parent.setIndexPage(0);
        });
        this.method_25321(new GunPackList.Entry(byName));

        this.byHandCheckbox = new Checkbox(0, 0, 10, 10, class_2561.method_43471("gui.tacz.gun_smith_table.filter.handgun"), false) {
            @Override
            public void method_25306() {
                super.method_25306();
                parent.method_25426();
                parent.setIndexPage(0);
            }
        };
        this.method_25321(new GunPackList.Entry(byHandCheckbox));

        Checkbox checkbox1 = new Checkbox(0, 0, 10, 10, class_2561.method_43471("gui.tacz.gun_smith_table.filter.all"), true) {
            @Override
            public void method_25306() {
                super.method_25306();
                gunPackList.forEach((checkbox) -> checkbox.selected = this.selected);
                updateSelectedNamespaces();
            }
        };
        this.method_25321(new GunPackList.Entry(checkbox1));

        for (String namespace : namespaces) {
            PackInfo packInfo = ClientAssetsManager.INSTANCE.getPackInfo(namespace);
            class_2561 name = packInfo == null ? class_2561.method_43470(namespace) : class_2561.method_43471(packInfo.getName());

            Checkbox checkbox = new Checkbox(0, 0, 10, 10, name, namespace, true) {
                @Override
                public void method_25306() {
                    super.method_25306();
                    checkbox1.selected = gunPackList.stream().allMatch(Checkbox::selected);
                    updateSelectedNamespaces();
                }
            };
            gunPackList.add(checkbox);
            selectedNamespaces.add(namespace);
            this.method_25321(new GunPackList.Entry(checkbox));
        }
    }

    public String getSearchText() {
        return byName.method_1882();
    }

    public boolean isByHandSelected() {
        return byHandCheckbox.selected;
    }

    public Set<String> namespaceList() {
        return selectedNamespaces;
    }

    public void updateSelectedNamespaces() {
        selectedNamespaces.clear();
        gunPackList.forEach((checkbox) -> {
            if (checkbox.selected) {
                selectedNamespaces.add(checkbox.getId());
            }
        });
        parent.method_25426();
        parent.setIndexPage(0);
    }

    protected int method_25329() {
        return this.method_55442() - 2;
    }

    @Override
    public void method_48579(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
        this.method_57715(pGuiGraphics);
        pGuiGraphics.method_25294(this.method_46426(), this.method_46427(), this.method_55442(), this.method_55443(), 0x80000000);
        int i = this.method_25329();
        int j = i + 6;

        this.method_49603(pGuiGraphics);
        this.method_25311(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        pGuiGraphics.method_44380();
        this.method_57713(pGuiGraphics);

        int i2 = this.method_25331();
        if (i2 > 0) {
            int j2 = (int)((float)((this.method_55443() - this.method_46427()) * (this.method_55443() - this.method_46427())) / (float)this.method_25317());
            j2 = class_3532.method_15340(j2, 32, this.method_55443() - this.method_46427() - 8);
            int k1 = (int)this.method_25341() * (this.method_55443() - this.method_46427() - j2) / i2 + this.method_46427();
            if (k1 < this.method_46427()) {
                k1 = this.method_46427();
            }
            pGuiGraphics.method_25294(i, k1, j, k1 + j2, -8355712);
            pGuiGraphics.method_25294(i, k1, j - 1, k1 + j2 - 1, -4144960);
        }
        this.method_25320(pGuiGraphics, pMouseX, pMouseY);

        RenderSystem.disableBlend();
    }

    public int method_25342() {
        return this.method_46426() + 4;
    }

    public int method_25322() {
        return this.field_22758;
    }

    public static class Entry extends class_4265.class_4266<GunPackList.Entry> {
        private final class_339 widget;

        public Entry(class_339 widget) {
            this.widget = widget;
        }

        @Override
        public List<? extends class_6379> method_37025() {
            return ImmutableList.of(widget);
        }

        @Override
        public void method_25343(class_332 pGuiGraphics, int pIndex, int pTop, int pLeft, int pWidth, int pHeight, int pMouseX, int pMouseY, boolean pHovering, float pPartialTick) {
            this.widget.method_46421(pLeft);
            this.widget.method_46419(pTop);
            this.widget.method_25394(pGuiGraphics, pMouseX, pMouseY, pPartialTick);
        }

        @Override
        public List<? extends class_364> method_25396() {
            return ImmutableList.of(widget);
        }
    }

    public static class Checkbox extends class_4264 {
        private static final class_2960 CHECKBOX = class_2960.method_60656("textures/gui/sprites/widget/checkbox.png");
        private static final class_2960 CHECKBOX_HIGHLIGHTED = class_2960.method_60656("textures/gui/sprites/widget/checkbox_highlighted.png");
        private static final class_2960 CHECKBOX_SELECTED = class_2960.method_60656("textures/gui/sprites/widget/checkbox_selected.png");
        private static final class_2960 CHECKBOX_SELECTED_HIGHLIGHTED = class_2960.method_60656("textures/gui/sprites/widget/checkbox_selected_highlighted.png");
        protected boolean selected;
        protected final boolean showLabel;
        private String id;

        public Checkbox(int pX, int pY, int pWidth, int pHeight, class_2561 pMessage, String id, boolean pSelected) {
            this(pX, pY, pWidth, pHeight, pMessage, pSelected, true);
            this.id = id;
        }

        public Checkbox(int pX, int pY, int pWidth, int pHeight, class_2561 pMessage, boolean pSelected) {
            this(pX, pY, pWidth, pHeight, pMessage, pSelected, true);
        }

        public Checkbox(int pX, int pY, int pWidth, int pHeight, class_2561 pMessage, boolean pSelected, boolean pShowLabel) {
            super(pX, pY, pWidth, pHeight, pMessage);
            this.selected = pSelected;
            this.showLabel = pShowLabel;
        }

        public String getId() {
            return id;
        }

        public void method_25306() {
            this.selected = !this.selected;
        }

        public boolean selected() {
            return this.selected;
        }

        public void method_47399(class_6382 pNarrationElementOutput) {
            pNarrationElementOutput.method_37034(class_6381.field_33788, this.method_25360());
            if (this.field_22763) {
                if (this.method_25370()) {
                    pNarrationElementOutput.method_37034(class_6381.field_33791, class_2561.method_43471("narration.checkbox.usage.focused"));
                } else {
                    pNarrationElementOutput.method_37034(class_6381.field_33791, class_2561.method_43471("narration.checkbox.usage.hovered"));
                }
            }

        }

        public void method_48579(class_332 pGuiGraphics, int pMouseX, int pMouseY, float pPartialTick) {
            class_310 minecraft = class_310.method_1551();
            RenderSystem.enableDepthTest();
            class_327 font = minecraft.field_1772;
            pGuiGraphics.method_51422(1.0F, 1.0F, 1.0F, this.field_22765);
            RenderSystem.enableBlend();
            class_2960 texture;
            if (this.method_25370()) {
                if (this.selected) {
                    texture = CHECKBOX_SELECTED_HIGHLIGHTED;
                } else {
                    texture = CHECKBOX_HIGHLIGHTED;
                }
            } else {
                if (this.selected) {
                    texture = CHECKBOX_SELECTED;
                } else {
                    texture = CHECKBOX;
                }
            }
            pGuiGraphics.method_25290(texture, this.method_46426(), this.method_46427(), 0.0F, 0.0F, 10, 10, 10, 10);
            pGuiGraphics.method_51422(1.0F, 1.0F, 1.0F, 1.0F);
            if (this.showLabel) {
                pGuiGraphics.method_27535(font, this.method_25369(), this.method_46426() + 24, this.method_46427() + (this.field_22759 - 8) / 2, 14737632 | class_3532.method_15386(this.field_22765 * 255.0F) << 24);
            }

        }
    }
}