package com.tacz.guns.client.renderer.crosshair;

import com.google.common.collect.Maps;
import com.tacz.guns.GunMod;
import java.util.Locale;
import java.util.Map;
import net.minecraft.class_2960;

public enum CrosshairType {
    EMPTY,
    DOT_1,
    CIRCLE_1,
    CIRCLE_2,
    CIRCLE_3,
    CROSS_1,
    CROSS_2,
    CROSS_3,
    CROSS_4,
    CROSS_5,
    CROSS_6,
    LINE_1,
    LINE_2,
    LINE_3,
    SQUARE_1,
    SQUARE_2,
    SQUARE_3,
    SQUARE_4,
    SQUARE_5,
    SQUARE_6,
    TRIDENT_1,
    TRIDENT_2;

    private static final Map<CrosshairType, class_2960> CACHE = Maps.newHashMap();

    public static class_2960 getTextureLocation(CrosshairType type) {
        class_2960 location = CACHE.get(type);
        if (location == null) {
            location = class_2960.method_60655(GunMod.MOD_ID, "textures/crosshair/normal/%s.png".formatted(type.name().toLowerCase(Locale.US)));
            CACHE.put(type, location);
        }
        return location;
    }
}
