package com.tacz.guns.client.renderer.other;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.resource.pojo.display.gun.LayerGunShow;
import com.tacz.guns.util.math.MathUtil;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_811;
import net.minecraft.class_918;
import org.joml.Quaternionf;
import org.joml.Vector3f;

public class HumanoidOffhandRender {
    public static void renderGun(class_1309 entity, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        renderOffhandGun(entity, matrixStack, buffer, packedLight);
        renderHotbarGun(entity, matrixStack, buffer, packedLight);
    }

    private static void renderOffhandGun(class_1309 entity, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        class_1799 itemStack = entity.method_6079();
        if (itemStack.method_7960()) {
            return;
        }
        IGun iGun = IGun.getIGunOrNull(itemStack);
        if (iGun == null) {
            return;
        }
        TimelessAPI.getGunDisplay(itemStack).ifPresent(index -> {
            LayerGunShow offhandShow = index.getOffhandShow();
            renderGunItem(entity, matrixStack, buffer, packedLight, itemStack, offhandShow);
        });
    }

    private static void renderHotbarGun(class_1309 entity, class_4587 matrixStack, class_4597 buffer, int packedLight) {
        if (!(entity instanceof class_1657 player)) {
            return;
        }
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < 9; i++) {
            if (i == inventory.field_7545) {
                continue;
            }
            class_1799 stack = inventory.method_5438(i);
            renderHotbarGun(entity, matrixStack, buffer, packedLight, stack, i);
        }
    }

    private static void renderHotbarGun(class_1309 entity, class_4587 matrixStack, class_4597 buffer, int packedLight, class_1799 itemStack, int inventoryIndex) {
        if (itemStack.method_7960()) {
            return;
        }
        IGun iGun = IGun.getIGunOrNull(itemStack);
        if (iGun == null) {
            return;
        }
        TimelessAPI.getGunDisplay(itemStack).ifPresent(display -> {
            var hotbarShow = display.getHotbarShow();
            if (hotbarShow == null || hotbarShow.isEmpty()) {
                return;
            }
            if (!hotbarShow.containsKey(inventoryIndex)) {
                return;
            }
            LayerGunShow gunShow = hotbarShow.get(inventoryIndex);
            renderGunItem(entity, matrixStack, buffer, packedLight, itemStack, gunShow);
        });
    }

    private static void renderGunItem(class_1309 entity, class_4587 matrixStack, class_4597 buffer, int packedLight, class_1799 itemStack, LayerGunShow offhandShow) {
        class_918 renderer = class_310.method_1551().method_1480();
        Vector3f pos = offhandShow.getPos();
        Vector3f rotate = offhandShow.getRotate();
        Vector3f scale = offhandShow.getScale();
        matrixStack.method_22903();
        matrixStack.method_22904(-pos.x() / 16f, 1.5 - pos.y() / 16f, pos.z() / 16f);
        matrixStack.method_22905(-scale.x(), -scale.y(), scale.z());
        Quaternionf rotation = new Quaternionf();
        MathUtil.toQuaternion((float) Math.toRadians(rotate.x), (float) Math.toRadians(rotate.y), (float) Math.toRadians(rotate.z), rotation);
        matrixStack.method_22907(rotation);
        renderer.method_23178(itemStack, class_811.field_4319, packedLight, class_4608.field_21444, matrixStack, buffer, entity.method_37908(), entity.method_5628());
        matrixStack.method_22909();
    }
}
