package com.tacz.guns.compat.iris;

import com.tacz.guns.init.CompatRegistry;
import net.fabricmc.loader.api.FabricLoader;
import net.irisshaders.batchedentityrendering.impl.FullyBufferedMultiBufferSource;
import net.irisshaders.iris.Iris;
import net.irisshaders.iris.api.v0.IrisApi;
import net.irisshaders.iris.shadows.ShadowRenderingState;
import net.minecraft.class_4597;
import java.util.function.Function;
import java.util.function.Supplier;

public final class IrisCompat {
    private static Function<class_4597.class_4598, Boolean> END_BATCH_FUNCTION;
    private static Supplier<Boolean> IS_RENDER_SHADOW_SUPPER;

    public static void initCompat() {
        FabricLoader.getInstance().getModContainer(CompatRegistry.IRIS).ifPresent(mod -> {
            END_BATCH_FUNCTION = IrisCompat::endBatchInner;
            IS_RENDER_SHADOW_SUPPER = IrisCompat::isRenderShadowInner;
        });
    }

    public static boolean isPackInUseQuick() {
        if (FabricLoader.getInstance().isModLoaded(CompatRegistry.IRIS)) {
            return Iris.isPackInUseQuick();
        }
        return false;
    }

    public static boolean isRenderShadow() {
        if (FabricLoader.getInstance().isModLoaded(CompatRegistry.IRIS)) {
            return IS_RENDER_SHADOW_SUPPER.get();
        }
        return false;
    }

    public static boolean isUsingRenderPack() {
        if (FabricLoader.getInstance().isModLoaded(CompatRegistry.IRIS)) {
            return IrisApi.getInstance().isShaderPackInUse();
        }
        return false;
    }

    public static boolean endBatch(class_4597.class_4598 bufferSource) {
        if (FabricLoader.getInstance().isModLoaded(CompatRegistry.IRIS)) {
            return END_BATCH_FUNCTION.apply(bufferSource);
        }
        return false;
    }

    private static boolean isRenderShadowInner() {
        return ShadowRenderingState.areShadowsCurrentlyBeingRendered();
    }

    private static boolean endBatchInner(class_4597.class_4598 bufferSource) {
        if (bufferSource instanceof FullyBufferedMultiBufferSource fullyBufferedMultiBufferSource) {
            fullyBufferedMultiBufferSource.method_22993();
            return true;
        }
        return false;
    }
}
