package com.tacz.guns.crafting.result;

import com.tacz.guns.GunMod;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.api.item.builder.AmmoItemBuilder;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.resource.pojo.data.block.TabConfig;
import com.tacz.guns.resource.pojo.data.recipe.GunResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.EnumMap;
import java.util.Locale;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_7225;
import net.minecraft.class_9279;
import net.minecraft.class_9334;


/**
 * 配方加载时部分物品的上下文还未完成初始化<br/>
 * 等待到实际需要使用配方时再进行初始化
 */
public class RawGunTableResult {
    private final String type;
    private final int count;
    private final class_2960 id;
    @Nullable
    private GunResult extraData;
    @Nullable
    private class_2487 nbt;

    public RawGunTableResult(@NotNull String type, @NotNull class_2960 id, int count) {
        this.type = type;
        this.id = id;
        this.count = count;
    }

    public void setExtraData(@Nullable GunResult extraData) {
        this.extraData = extraData;
    }

    public void setNbt(@Nullable class_2487 nbt) {
        this.nbt = nbt;
    }

    public static GunSmithTableResult init(class_7225.class_7874 provider, RawGunTableResult raw) {
        GunSmithTableResult result = switch (raw.type) {
            case GunSmithTableResult.GUN -> raw.getGunStack(provider);
            case GunSmithTableResult.AMMO -> raw.getAmmoStack();
            case GunSmithTableResult.ATTACHMENT -> raw.getAttachmentStack();
            default -> new GunSmithTableResult(class_1799.field_8037, TabConfig.TAB_EMPTY);
        };
        if (raw.nbt != null) {
            result.getResult().method_57368(class_9334.field_49628, class_9279.field_49302, data -> data.method_57451(tag -> {
                for (String key : raw.nbt.method_10541()) {
                    class_2520 value = raw.nbt.method_10580(key);
                    if (value != null) {
                        tag.method_10566(key, value);
                    }
                }
            }));
        }
        return result;
    }

    private GunSmithTableResult getGunStack(class_7225.class_7874 provider) {
        int ammoCount;
        EnumMap<AttachmentType, class_2960> attachments;
        if (extraData != null) {
            ammoCount = Math.max(0, extraData.getAmmoCount());
            attachments = extraData.getAttachments();
        } else {
            ammoCount = 0;
            attachments = new EnumMap<>(AttachmentType.class);
        }

        return TimelessAPI.getCommonGunIndex(id).map(gunIndex -> {
            class_1799 itemStack = GunItemBuilder.create()
                    .setCount(count)
                    .setId(id)
                    .setAmmoCount(ammoCount)
                    .setAmmoInBarrel(false)
                    .putAllAttachment(attachments)
                    .setFireMode(gunIndex.getGunData().getFireModeSet().getFirst()).build(provider);
            String raw = gunIndex.getType();
            if (!raw.contains(":")) {
                raw = GunMod.MOD_ID + ":" + raw;
            }
            class_2960 group = class_2960.method_12829(raw);
            return new GunSmithTableResult(itemStack, group);
        }).orElse(new GunSmithTableResult(class_1799.field_8037, TabConfig.TAB_EMPTY));
    }

    private GunSmithTableResult getAmmoStack() {
        return new GunSmithTableResult(AmmoItemBuilder.create().setCount(count).setId(id).build(), TabConfig.TAB_AMMO);
    }

    private GunSmithTableResult getAttachmentStack() {
        return TimelessAPI.getCommonAttachmentIndex(id).map(attachmentIndex -> {
            class_1799 itemStack = AttachmentItemBuilder.create().setCount(count).setId(id).build();
            String raw = attachmentIndex.getType().name().toLowerCase(Locale.US);
            if (!raw.contains(":")) {
                raw = GunMod.MOD_ID + ":" + raw;
            }
            class_2960 group = class_2960.method_12829(raw);
            return new GunSmithTableResult(itemStack, group);
        }).orElse(new GunSmithTableResult(class_1799.field_8037, TabConfig.TAB_EMPTY));
    }
}