package com.tacz.guns.entity.shooter;

import cn.sh1rocu.tacz.api.mixin.ForcePoseInjection;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IGun;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_4050;

public class LivingEntityCrawl {
    private final class_1309 shooter;
    private final ShooterDataHolder data;

    public LivingEntityCrawl(class_1309 shooter, ShooterDataHolder data) {
        this.shooter = shooter;
        this.data = data;
    }

    public void crawl(boolean isCrawl) {
        data.isCrawling = isCrawl;
    }

    public void tickCrawling() {
        // currentGunItem 如果为 null，则取消趴下状态
        if (data.currentGunItem == null || !(data.currentGunItem.get().method_7909() instanceof IGun iGun)) {
            data.isCrawling = false;
            this.setCrawlPose();
            return;
        }
        class_1799 currentGunItem = data.currentGunItem.get();
        // 不允许趴下的武器，则取消趴下状态
        if (!iGun.isCanCrawl(currentGunItem)) {
            data.isCrawling = false;
            this.setCrawlPose();
            return;
        }
        // 如果获取不到 gunIndex，则取消趴下状态
        class_2960 gunId = iGun.getGunId(currentGunItem);
        if (TimelessAPI.getCommonGunIndex(gunId).isEmpty()) {
            data.isCrawling = false;
            this.setCrawlPose();
            return;
        }
        // 如果是观察者模型、骑乘、跳跃、在游泳、不在地上，取消
        if (shooter.method_7325() || shooter.method_5765() || shooter.field_6282 || shooter.method_5681() || !shooter.method_24828()) {
            data.isCrawling = false;
            this.setCrawlPose();
            return;
        }
        this.setCrawlPose();
    }

    private void setCrawlPose() {
        if (data.isCrawling) {
            if (shooter instanceof class_1657 player) {
                ((ForcePoseInjection) player).tacz$setForcedPose(class_4050.field_18079);
            } else {
                this.shooter.method_18380(class_4050.field_18079);
            }
        } else {
            if (shooter instanceof class_1657 player) {
                ((ForcePoseInjection) player).tacz$setForcedPose(null);
            }
        }
    }
}
