package com.tacz.guns.resource.modifier.custom;

import com.google.common.collect.Lists;
import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.ExplosionData;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import javax.annotation.Nullable;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import java.util.List;

public class ExplosionModifier implements IAttachmentModifier<ExplosionModifier.ExplosionModifierValue, ExplosionData> {
    public static final String ID = GunProperties.EXPLOSION.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    public JsonProperty<ExplosionModifierValue> readJson(String json) {
        Data data = CommonAssetsManager.GSON.fromJson(json, Data.class);
        return new ExplosionJsonProperty(data.getExplosion());
    }

    @Override
    public CacheValue<ExplosionData> initCache(class_1799 gunItem, GunData gunData) {
        ExplosionData explosionData = gunData.getBulletData().getExplosionData();
        if (explosionData == null) {
            explosionData = new ExplosionData(false, 0.5f, 2, false, 30, false);
        }
        return new CacheValue<>(explosionData);
    }

    @Override
    public void eval(List<ExplosionModifierValue> modifiedValues, CacheValue<ExplosionData> cache) {
        ExplosionData cacheValue = cache.getValue();

        List<Boolean> explodeValues = Lists.newArrayList();
        explodeValues.add(cacheValue.isExplode());
        List<Modifier> radiusValues = Lists.newArrayList();
        List<Modifier> damageValues = Lists.newArrayList();
        List<Boolean> knockbackValues = Lists.newArrayList();
        knockbackValues.add(cacheValue.isKnockback());
        List<Boolean> destroyBlockValues = Lists.newArrayList();
        destroyBlockValues.add(cacheValue.isDestroyBlock());
        List<Modifier> delayValues = Lists.newArrayList();

        modifiedValues.forEach(v -> {
            explodeValues.add(v.explode);
            radiusValues.add(v.radius);
            damageValues.add(v.damage);
            knockbackValues.add(v.knockback);
            destroyBlockValues.add(v.destroyBlock);
            delayValues.add(v.delay);
        });

        boolean explode = cacheValue.isExplode() || AttachmentPropertyManager.eval(explodeValues, false);
        // 如果还是没有爆炸，那就没必要计算后面数值了
        if (!explode) {
            return;
        }
        float radius = (float) AttachmentPropertyManager.eval(radiusValues, cacheValue.getRadius());
        float damage = (float) AttachmentPropertyManager.eval(damageValues, cacheValue.getDamage());
        boolean knockback = AttachmentPropertyManager.eval(knockbackValues, false);
        boolean destroyBlock = AttachmentPropertyManager.eval(destroyBlockValues, false);
        float delay = (float) AttachmentPropertyManager.eval(delayValues, cacheValue.getDelay());
        ExplosionData explosionData = new ExplosionData(true, radius, damage, knockback, delay, destroyBlock);
        cache.setValue(explosionData);
    }

    public static class ExplosionJsonProperty extends JsonProperty<ExplosionModifierValue> {
        public ExplosionJsonProperty(ExplosionModifierValue value) {
            super(value);
        }

        @Override
        public void initComponents() {
            ExplosionModifierValue modifierValue = getValue();
            if (modifierValue != null && modifierValue.explode) {
                components.add(class_2561.method_43471("tooltip.tacz.attachment.explosion").method_27692(class_124.field_1065));
            }
        }
    }

    private static class Data {
        @Nullable
        @SerializedName("explosion")
        private ExplosionModifierValue explosion = null;

        @Nullable
        public ExplosionModifierValue getExplosion() {
            return explosion;
        }
    }

    public static class ExplosionModifierValue {
        /**
         * 需要显式开启爆炸！
         */
        @SerializedName("explode")
        private boolean explode = false;

        @SerializedName("radius")
        private Modifier radius = new Modifier();

        @SerializedName("damage")
        private Modifier damage = new Modifier();

        @SerializedName("knockback")
        private boolean knockback = false;

        @SerializedName("destroy_block")
        private boolean destroyBlock = false;

        @SerializedName("delay")
        private Modifier delay = new Modifier();

        public boolean isExplode() {
            return explode;
        }
    }
}
