package cn.sh1rocu.tacz.mixin.client;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.event.PreventsHotbarEvent;
import com.tacz.guns.client.event.RenderCrosshairEvent;
import com.tacz.guns.compat.immediatelyfast.ImmediatelyFastCompat;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_310;
import net.minecraft.class_329;
import net.minecraft.class_332;
import net.minecraft.class_746;

@Mixin(class_329.class)
public class GuiMixin {
    @Inject(method = "renderSlot", at = @At("HEAD"))
    private void tacz$renderHotbarItemPre(class_332 context, int x, int y, float f, class_1657 player, class_1799 stack, int seed, CallbackInfo ci) {
        ImmediatelyFastCompat.renderHotbarItem(stack, true);
    }

    @Inject(method = "renderSlot", at = @At("RETURN"))
    private void tacz$renderHotbarItemPost(class_332 context, int x, int y, float f, class_1657 player, class_1799 stack, int seed, CallbackInfo ci) {
        ImmediatelyFastCompat.renderHotbarItem(stack, false);
    }

    @Inject(method = "render", at = @At("HEAD"), cancellable = true)
    private void tacz$onRender(class_332 context, float tickDelta, CallbackInfo ci) {
        AtomicBoolean cancelled = new AtomicBoolean(false);
        PreventsHotbarEvent.onRenderHotbarEvent(cancelled);
        if (cancelled.get()) {
            ci.cancel();
        }
    }

    @Inject(method = "render", at = @At(value = "INVOKE", target = "Lcom/mojang/blaze3d/systems/RenderSystem;enableBlend()V", ordinal = 1, shift = At.Shift.BEFORE, remap = false))
    private void tacz$renderCrosshairPre(class_332 context, float tickDelta, CallbackInfo ci) {
        RenderCrosshairEvent.onRenderOverlay(context, class_310.method_1551().method_22683());
    }

    // 需要渲染枪械准心时取消原版渲染
    @Inject(method = "renderCrosshair", at = @At("HEAD"), cancellable = true)
    private void tacz$renderCrosshair(class_332 context, CallbackInfo ci) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        if (!IGun.mainHandHoldGun(player)) {
            return;
        }

        RenderSystem.defaultBlendFunc();

        ci.cancel();
    }
}
