package cn.sh1rocu.tacz.mixin.common;

import cn.sh1rocu.tacz.util.forge.PartialNBTIngredient;
import cn.sh1rocu.tacz.util.forge.StrictNBTIngredient;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1856;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1856.class)
public abstract class IngredientMixin {
    @Shadow
    public abstract JsonElement toJson();

    @Inject(method = "toJson", at = @At("HEAD"), cancellable = true)
    private void tacz$injectToJson(CallbackInfoReturnable<JsonElement> cir) {
        CustomIngredient customIngredient = ((class_1856) (Object) this).getCustomIngredient();
        if (customIngredient != null) {
            if (customIngredient instanceof StrictNBTIngredient strictNBTIngredient) {
                JsonObject obj = new JsonObject();
                strictNBTIngredient.getSerializer().write(obj, strictNBTIngredient);
                cir.setReturnValue(obj);
            } else if (customIngredient instanceof PartialNBTIngredient partialNBTIngredient) {
                JsonObject obj = new JsonObject();
                partialNBTIngredient.getSerializer().write(obj, partialNBTIngredient);
                cir.setReturnValue(obj);
            }
        }
    }

    @Inject(
            at = @At(
                    value = "INVOKE",
                    target = "Lnet/minecraft/world/item/crafting/Ingredient;valueFromJson(Lcom/google/gson/JsonObject;)Lnet/minecraft/world/item/crafting/Ingredient$Value;",
                    ordinal = 0
            ),
            method = "fromJson(Lcom/google/gson/JsonElement;Z)Lnet/minecraft/world/item/crafting/Ingredient;",
            cancellable = true
    )
    private static void tacz$injectFromJson(JsonElement json, boolean requireNotEmpty, CallbackInfoReturnable<class_1856> cir) {
        JsonObject obj = json.getAsJsonObject();

        if (obj.has("type")) {
            class_2960 id = new class_2960(class_3518.method_15265(obj, "type"));
            CustomIngredientSerializer<?> serializer = null;

            if (id.equals(StrictNBTIngredient.ID)) serializer = StrictNBTIngredient.Serializer.INSTANCE;
            else if (id.equals(PartialNBTIngredient.ID)) serializer = PartialNBTIngredient.Serializer.INSTANCE;

            if (serializer != null) {
                cir.setReturnValue(serializer.read(obj).toVanilla());
            }
        }
    }

    @Inject(
            at = @At("HEAD"),
            method = "fromNetwork",
            cancellable = true
    )
    private static void tacz$injectFromNetwork(class_2540 buf, CallbackInfoReturnable<class_1856> cir) {
        int index = buf.readerIndex();

        if (buf.method_19772().equals("tacz_ingredient")) {
            class_2960 id = buf.method_10810();
            CustomIngredientSerializer<?> serializer = null;

            if (id.equals(StrictNBTIngredient.ID)) serializer = StrictNBTIngredient.Serializer.INSTANCE;
            else if (id.equals(PartialNBTIngredient.ID)) serializer = PartialNBTIngredient.Serializer.INSTANCE;

            if (serializer != null) {
                cir.setReturnValue(serializer.read(buf).toVanilla());
            }
        } else {
            buf.readerIndex(index);
        }
    }

    @SuppressWarnings({"rawtypes", "unchecked"})
    @Inject(method = "toNetwork", at = @At("HEAD"), cancellable = true)
    private void tacz$injectToNetwork(class_2540 buffer, CallbackInfo ci) {
        JsonElement element = this.toJson();
        if (element != null && !element.isJsonNull() && element.isJsonObject()) {
            JsonObject obj = element.getAsJsonObject();
            if (obj.has("type")) {
                class_2960 id = new class_2960(class_3518.method_15265(obj, "type"));
                CustomIngredientSerializer serializer = null;

                if (id.equals(StrictNBTIngredient.ID)) serializer = StrictNBTIngredient.Serializer.INSTANCE;
                else if (id.equals(PartialNBTIngredient.ID)) serializer = PartialNBTIngredient.Serializer.INSTANCE;

                if (serializer != null) {
                    buffer.method_10814("tacz_ingredient");
                    buffer.method_10812(id);
                    serializer.write(buffer, serializer.read(obj));
                    ci.cancel();
                }
            }
        }
    }
}
