package cn.sh1rocu.tacz.mixin.common;

import cn.sh1rocu.tacz.api.event.EntityJoinLevelEvent;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Supplier;
import net.minecraft.class_1937;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3695;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;

@Mixin(class_3218.class)
public abstract class ServerLevelMixin extends class_1937 {
    protected ServerLevelMixin(class_5269 levelData, class_5321<class_1937> dimension, class_5455 registryAccess, class_6880<class_2874> dimensionTypeRegistration, Supplier<class_3695> profiler, boolean isClientSide, boolean isDebug, long biomeZoomSeed, int maxChainedNeighborUpdates) {
        super(levelData, dimension, registryAccess, dimensionTypeRegistration, profiler, isClientSide, isDebug, biomeZoomSeed, maxChainedNeighborUpdates);
    }

    @Inject(method = "addPlayer", at = @At("HEAD"), cancellable = true)
    public void tlm$addEntityEvent(class_3222 serverPlayer, CallbackInfo ci) {
        EntityJoinLevelEvent event = new EntityJoinLevelEvent(serverPlayer, this);
        EntityJoinLevelEvent.CALLBACK.invoker().post(event);
        if (event.isCanceled())
            ci.cancel();
    }
}