package cn.sh1rocu.tacz.util.forge;

import com.google.gson.JsonObject;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredient;
import net.fabricmc.fabric.api.recipe.v1.ingredient.CustomIngredientSerializer;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;

import java.util.List;
import java.util.stream.Stream;

public class StrictNBTIngredient implements CustomIngredient {
    private final class_1799 stack;

    protected StrictNBTIngredient(class_1799 stack) {
        this.stack = stack;
    }

    /**
     * Creates a new ingredient matching the given stack and tag
     */
    public static StrictNBTIngredient of(class_1799 stack) {
        return new StrictNBTIngredient(stack);
    }

    @Override
    public boolean test(@Nullable class_1799 input) {
        if (input == null)
            return false;
        //Can't use areItemStacksEqualUsingNBTShareTag because it compares stack size as well
        return this.stack.method_7909() == input.method_7909() && this.stack.method_7919() == input.method_7919() && areShareTagsEqual(this.stack, input);
    }

    private static boolean areShareTagsEqual(class_1799 stack, class_1799 other) {
        class_2487 shareTagA = stack.method_7969();
        class_2487 shareTagB = other.method_7969();
        if (shareTagA == null)
            return shareTagB == null;
        else
            return shareTagB != null && shareTagA.equals(shareTagB);
    }

    @Override
    public List<class_1799> getMatchingStacks() {
        return Stream.of(stack).toList();
    }

    @Override
    public boolean requiresTesting() {
        return true;
    }

    @Override
    public CustomIngredientSerializer<StrictNBTIngredient> getSerializer() {
        return Serializer.INSTANCE;
    }

    public static final class_2960 ID = new class_2960("forge", "nbt");

    public static class Serializer implements CustomIngredientSerializer<StrictNBTIngredient> {
        public static final Serializer INSTANCE = new Serializer();

        @Override
        public class_2960 getIdentifier() {
            return ID;
        }

        @Override
        public StrictNBTIngredient read(JsonObject json) {
            return new StrictNBTIngredient(CraftingHelper.getItemStack(json, true));
        }

        @Override
        public void write(JsonObject json, StrictNBTIngredient ingredient) {
            json.addProperty("type", ID.toString());
            json.addProperty("item", class_7923.field_41178.method_10221(ingredient.stack.method_7909()).toString());
            json.addProperty("count", ingredient.stack.method_7947());
            if (ingredient.stack.method_7985())
                json.addProperty("nbt", ingredient.stack.method_7969().toString());
        }

        @Override
        public StrictNBTIngredient read(class_2540 buffer) {
            return new StrictNBTIngredient(buffer.method_10819());
        }

        @Override
        public void write(class_2540 buffer, StrictNBTIngredient ingredient) {
            buffer.method_10793(ingredient.stack);
        }
    }
}
