package cn.sh1rocu.tacz.util.itemhandler;

import cn.sh1rocu.tacz.util.itemhandler.entity.player.PlayerMainInvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

import java.util.Objects;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3532;

public class ItemHandlerHelper {
    public static @NotNull class_1799 insertItem(IItemHandler dest, @NotNull class_1799 stack, boolean simulate) {
        if (dest != null && !stack.method_7960()) {
            for (int i = 0; i < dest.getSlots(); ++i) {
                stack = dest.insertItem(i, stack, simulate);
                if (stack.method_7960()) {
                    return class_1799.field_8037;
                }
            }

            return stack;
        } else {
            return stack;
        }
    }

    public static boolean canItemStacksStack(@NotNull class_1799 a, @NotNull class_1799 b) {
        if (!a.method_7960() && class_1799.method_7984(a, b) && a.method_7985() == b.method_7985()) {
            return (!a.method_7985() || Objects.equals(a.method_7969(), b.method_7969())) /*&& a.areCapsCompatible(b)*/;
        } else {
            return false;
        }
    }

    public static boolean canItemStacksStackRelaxed(@NotNull class_1799 a, @NotNull class_1799 b) {
        if (!a.method_7960() && !b.method_7960() && a.method_7909() == b.method_7909()) {
            if (!a.method_7946()) {
                return false;
            } else if (a.method_7985() != b.method_7985()) {
                return false;
            } else {
                return (!a.method_7985() || a.method_7969().equals(b.method_7969())) /*&& a.areCapsCompatible(b)*/;
            }
        } else {
            return false;
        }
    }

    public static @NotNull class_1799 copyStackWithSize(@NotNull class_1799 itemStack, int size) {
        if (size == 0) {
            return class_1799.field_8037;
        } else {
            class_1799 copy = itemStack.method_7972();
            copy.method_7939(size);
            return copy;
        }
    }

    public static @NotNull class_1799 insertItemStacked(IItemHandler inventory, @NotNull class_1799 stack, boolean simulate) {
        if (inventory != null && !stack.method_7960()) {
            if (!stack.method_7946()) {
                return insertItem(inventory, stack, simulate);
            } else {
                int sizeInventory = inventory.getSlots();

                for (int i = 0; i < sizeInventory; ++i) {
                    class_1799 slot = inventory.getStackInSlot(i);
                    if (canItemStacksStackRelaxed(slot, stack)) {
                        stack = inventory.insertItem(i, stack, simulate);
                        if (stack.method_7960()) {
                            break;
                        }
                    }
                }

                if (!stack.method_7960()) {
                    for (int i = 0; i < sizeInventory; ++i) {
                        if (inventory.getStackInSlot(i).method_7960()) {
                            stack = inventory.insertItem(i, stack, simulate);
                            if (stack.method_7960()) {
                                break;
                            }
                        }
                    }
                }

                return stack;
            }
        } else {
            return stack;
        }
    }

    public static void giveItemToPlayer(class_1657 player, @NotNull class_1799 stack) {
        giveItemToPlayer(player, stack, -1);
    }

    public static void giveItemToPlayer(class_1657 player, @NotNull class_1799 stack, int preferredSlot) {
        if (!stack.method_7960()) {
            IItemHandler inventory = new PlayerMainInvWrapper(player.method_31548());
            class_1937 level = player.method_37908();
            class_1799 remainder = stack;
            if (preferredSlot >= 0 && preferredSlot < inventory.getSlots()) {
                remainder = inventory.insertItem(preferredSlot, stack, false);
            }

            if (!remainder.method_7960()) {
                remainder = insertItemStacked(inventory, remainder, false);
            }

            if (remainder.method_7960() || remainder.method_7947() != stack.method_7947()) {
                level.method_43128((class_1657) null, player.method_23317(), player.method_23318() + (double) 0.5F, player.method_23321(), class_3417.field_15197, class_3419.field_15248, 0.2F, ((level.field_9229.method_43057() - level.field_9229.method_43057()) * 0.7F + 1.0F) * 2.0F);
            }

            if (!remainder.method_7960() && !level.field_9236) {
                class_1542 entityitem = new class_1542(level, player.method_23317(), player.method_23318() + (double) 0.5F, player.method_23321(), remainder);
                entityitem.method_6982(40);
                entityitem.method_18799(entityitem.method_18798().method_18805((double) 0.0F, (double) 1.0F, (double) 0.0F));
                level.method_8649(entityitem);
            }

        }
    }

    public static int calcRedstoneFromInventory(@Nullable IItemHandler inv) {
        if (inv == null) {
            return 0;
        } else {
            int itemsFound = 0;
            float proportion = 0.0F;

            for (int j = 0; j < inv.getSlots(); ++j) {
                class_1799 itemstack = inv.getStackInSlot(j);
                if (!itemstack.method_7960()) {
                    proportion += (float) itemstack.method_7947() / (float) Math.min(inv.getSlotLimit(j), itemstack.method_7914());
                    ++itemsFound;
                }
            }

            proportion /= (float) inv.getSlots();
            return class_3532.method_15375(proportion * 14.0F) + (itemsFound > 0 ? 1 : 0);
        }
    }
}
