package com.tacz.guns.api.item;

import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public interface IAmmo {
    /**
     * @return 如果物品类型为 IAttachment 则返回显式转换后的实例，否则返回 null。
     */
    @Nullable
    static IAmmo getIAmmoOrNull(@Nullable class_1799 stack) {
        if (stack == null) {
            return null;
        }
        if (stack.method_7909() instanceof IAmmo iAmmo) {
            return iAmmo;
        }
        return null;
    }

    /**
     * 获取弹药 ID
     *
     * @param ammo 输入物品
     * @return 弹药 ID
     */
    class_2960 getAmmoId(class_1799 ammo);

    /**
     * 设置弹药 ID
     */
    void setAmmoId(class_1799 ammo, @Nullable class_2960 ammoId);

    /**
     * 弹药是否属于这把枪
     *
     * @param gun  检查的枪械物品
     * @param ammo 检查的子弹物品
     * @return 是否属于这把枪
     */
    boolean isAmmoOfGun(class_1799 gun, class_1799 ammo);
}
