package com.tacz.guns.client.gui;

import cn.sh1rocu.tacz.mixin.accessor.ScreenAccessor;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.gui.components.FlatColorButton;
import com.tacz.guns.client.gui.components.GunPackList;
import com.tacz.guns.client.gui.components.smith.ResultButton;
import com.tacz.guns.client.gui.components.smith.TypeButton;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.PackInfo;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.init.ModRecipe;
import com.tacz.guns.inventory.GunSmithTableMenu;
import com.tacz.guns.network.message.ClientMessageCraft;
import com.tacz.guns.resource.filter.RecipeFilter;
import com.tacz.guns.resource.pojo.data.block.TabConfig;
import com.tacz.guns.util.RenderDistance;
import it.unimi.dsi.fastutil.Pair;
import it.unimi.dsi.fastutil.ints.Int2IntArrayMap;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1041;
import net.minecraft.class_1059;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1661;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_407;
import net.minecraft.class_4587;
import net.minecraft.class_4597;
import net.minecraft.class_4608;
import net.minecraft.class_465;
import net.minecraft.class_5481;
import net.minecraft.class_746;
import net.minecraft.class_7833;
import net.minecraft.class_7919;
import net.minecraft.class_811;
import org.apache.commons.lang3.StringUtils;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;
import java.util.*;

public class GunSmithTableScreen extends class_465<GunSmithTableMenu> {
    private static final class_2960 TEXTURE = new class_2960(GunMod.MOD_ID, "textures/gui/gun_smith_table.png");
    private static final class_2960 SIDE = new class_2960(GunMod.MOD_ID, "textures/gui/gun_smith_table_side.png");

    private final LinkedHashMap<class_2960, TabConfig> recipeKeys = Maps.newLinkedHashMap();
    private final Map<class_2960, List<class_2960>> recipes = Maps.newLinkedHashMap();

    private int typePage;
    private class_2960 selectedType = null;
    private List<class_2960> selectedRecipeList = new ArrayList<>();

    private int indexPage;
    private @Nullable GunSmithTableRecipe selectedRecipe;
    private @Nullable Int2IntArrayMap playerIngredientCount;

    private int scale = 70;
    private boolean filterEnabled = false;
    private GunPackList filterList;

    public GunSmithTableScreen(GunSmithTableMenu menu, class_1661 inventory, class_2561 title) {
        super(menu, inventory, title);
        this.field_2792 = 344;
        this.field_2779 = 186;
        this.classifyRecipes();
        this.typePage = 0;
        this.indexPage = 0;
        this.selectedRecipe = this.getSelectedRecipe(selectedRecipeList != null && !this.selectedRecipeList.isEmpty() ? this.selectedRecipeList.get(0) : null);
        this.getPlayerIngredientCount(this.selectedRecipe);
    }

    public static void drawModCenteredString(class_332 gui, class_327 font, class_2561 component, int pX, int pY, int color) {
        class_5481 text = component.method_30937();
        gui.method_51430(font, text, pX - font.method_30880(text) / 2, pY, color, false);
    }

    private void classifyRecipes() {
        this.recipes.clear();
        this.recipeKeys.clear();
        class_2960 blockId = field_2797.getBlockId();
        if (blockId == null) {
            return;
        }
        Map<class_2960, List<class_2960>> recipes = Maps.newLinkedHashMap();
        Map<class_2960, TabConfig> recipeKeys = Maps.newLinkedHashMap();

        TimelessAPI.getCommonBlockIndex(blockId).ifPresent(blockIndex -> {
            var tabs = blockIndex.getData().getTabs();
            if (DefaultAssets.DEFAULT_BLOCK_ID.equals(blockId) && !SyncConfig.ENABLE_TABLE_FILTER.get()) {
                tabs = TabConfig.DEFAULT_TABS;
            }
            for (TabConfig tab : tabs) {
                recipes.put(tab.id(), Lists.newArrayList());
                recipeKeys.put(tab.id(), tab);
            }
        });

        List<Pair<class_2960, class_2960>> recipeIds = Lists.newArrayList();

        if (class_310.method_1551().field_1687 != null) {
            class_1863 recipeManager = class_310.method_1551().field_1687.method_8433();
            List<GunSmithTableRecipe> recipeList = recipeManager.method_30027(ModRecipe.GUN_SMITH_TABLE_CRAFTING);
            Set<String> namespaces = filterList != null ? filterList.namespaceList() : null;
            for (GunSmithTableRecipe recipe : recipeList) {
                class_2960 id = recipe.method_8114();
                if (namespaces != null && !namespaces.contains(id.method_12836())) {
                    continue;
                }
                if (!isSuitableForMainHand(recipe)) {
                    continue;
                }
                if (!isNameMatch(recipe)) {
                    continue;
                }

                class_2960 groupName = recipe.getResult().getGroup();
                if (recipeKeys.containsKey(groupName)) {
                    recipeIds.add(Pair.of(groupName, id));
                }
            }
        }

        TimelessAPI.getCommonBlockIndex(field_2797.getBlockId()).map(blockIndex -> {
            if (field_2797.getBlockId().equals(DefaultAssets.DEFAULT_BLOCK_ID) && !SyncConfig.ENABLE_TABLE_FILTER.get()) {
                return null;
            }
            RecipeFilter filter = blockIndex.getFilter();
            if (filter != null) {
                return filter.filter(recipeIds, Pair::value);
            }
            return null;
        }).orElse(recipeIds).forEach(entry -> {
            class_2960 groupName = entry.key();
            if (recipeKeys.containsKey(groupName)) {
                recipes.computeIfAbsent(groupName, g -> Lists.newArrayList()).add(entry.value());
            }
        });

        for (var entry : recipes.entrySet()) {
            if (!entry.getValue().isEmpty()) {
                this.recipes.put(entry.getKey(), entry.getValue());
                this.recipeKeys.put(entry.getKey(), recipeKeys.get(entry.getKey()));
            }
        }

        if (!recipeKeys.containsKey(selectedType)) {
            selectedType = null;
            selectedRecipeList = null;
        }

        if (!this.recipeKeys.keySet().isEmpty()) {
            if (selectedType == null) {
                selectedType = this.recipeKeys.keySet().iterator().next();
            }
        }

        if (selectedType != null) {
            selectedRecipeList = this.recipes.get(selectedType);
        }
    }

    private boolean isNameMatch(GunSmithTableRecipe recipe) {
        if (filterList != null && StringUtils.isNotBlank(filterList.getSearchText())) {
            String searchText = filterList.getSearchText().toLowerCase();
            class_2561 name = recipe.getResult().getResult().method_7964();
            return name.getString().toLowerCase().contains(searchText);
        }
        return true;
    }

    private boolean isSuitableForMainHand(GunSmithTableRecipe recipe) {
        if (filterList != null && filterList.isByHandSelected()) {
            class_1799 result = recipe.getResult().getResult();

            class_310 minecraft = class_310.method_1551();
            class_1799 stack = minecraft.field_1724 != null ? minecraft.field_1724.method_6047() : class_1799.field_8037;
            if (stack.method_7909() instanceof IGun igun) {
                if (result.method_7909() instanceof IAmmo iAmmo) {
                    return iAmmo.isAmmoOfGun(stack, result);
                }
                if (result.method_7909() instanceof IAttachment) {
                    return igun.allowAttachment(stack, result);
                }
                return false;
            }
            if (stack.method_7909() instanceof IAttachment) {
                if (result.method_7909() instanceof IGun iGun) {
                    return iGun.allowAttachment(result, stack);
                }
                return false;
            }
            if (stack.method_7909() instanceof IAmmo iAmmo) {
                if (result.method_7909() instanceof IGun) {
                    return iAmmo.isAmmoOfGun(result, stack);
                }
                return false;
            }
        }
        return true;
    }

    public void setIndexPage(int indexPage) {
        this.indexPage = indexPage;
    }

    @Nullable
    private GunSmithTableRecipe getSelectedRecipe(class_2960 recipeId) {
        if (class_310.method_1551().field_1687 != null) {
            class_1863 recipeManager = class_310.method_1551().field_1687.method_8433();
            class_1860<?> recipe = recipeManager.method_8130(recipeId).orElse(null);
            if (recipe instanceof GunSmithTableRecipe) {
                return (GunSmithTableRecipe) recipe;
            }
        }
        return null;
    }

    private void getPlayerIngredientCount(GunSmithTableRecipe recipe) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null || recipe == null) {
            return;
        }
        List<GunSmithTableIngredient> ingredients = recipe.getInputs();
        int size = ingredients.size();
        this.playerIngredientCount = new Int2IntArrayMap(size);
        for (int i = 0; i < size; i++) {
            GunSmithTableIngredient ingredient = ingredients.get(i);
            class_1661 inventory = player.method_31548();
            int count = 0;
            for (class_1799 stack : inventory.field_7547) {
                if (!stack.method_7960() && ingredient.getIngredient().method_8093(stack)) {
                    count = count + stack.method_7947();
                }
            }
            playerIngredientCount.put(i, count);
        }
    }

    public void updateIngredientCount() {
        if (this.selectedRecipe != null) {
            this.getPlayerIngredientCount(selectedRecipe);
        }
        this.method_25426();
    }

    @Override
    public void method_25426() {
        super.method_25426();
        if (this.filterList == null) {
            this.filterList = new GunPackList(this.field_22787, 134, this.field_2779, field_2800, field_2800 + field_2779 + 1, 15, recipes, this);
        }
        this.filterList.method_25323(134, this.field_2779, field_2800, field_2800 + field_2779 + 1);
        this.filterList.method_25333(field_2776);

        this.classifyRecipes();
        this.method_37067();

        this.addTypePageButtons();
        this.addTypeButtons();
        this.addIndexPageButtons();
        this.addIndexButtons();
        this.method_37063(new FlatColorButton(field_2776 - 10, field_2800, 9, 9, class_2561.method_43470("F"), b -> {
            this.filterEnabled = !this.filterEnabled;
            this.method_25426();
        }).setTooltips("gui.tacz.gun_smith_table.filter"));
        if (this.filterEnabled) {
            this.method_37063(this.filterList);
        } else {
            this.addScaleButtons();
            this.addUrlButton();
        }
        this.addCraftButton();
    }

    private void addCraftButton() {
        this.method_37063(new class_344(field_2776 + 289, field_2800 + 162, 48, 18, 138, 164, 18, TEXTURE, b -> {
            if (this.selectedRecipe != null && playerIngredientCount != null) {
                // 检查是否能合成，不能就不发包
                List<GunSmithTableIngredient> inputs = selectedRecipe.getInputs();
                int size = inputs.size();
                for (int i = 0; i < size; i++) {
                    if (i >= playerIngredientCount.size()) {
                        return;
                    }
                    int hasCount = playerIngredientCount.get(i);
                    int needCount = inputs.get(i).getCount();
                    boolean isCreative = class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_7337();
                    // 拥有数量小于需求数量，不发包
                    if (hasCount < needCount && !isCreative) {
                        return;
                    }
                }
                ClientPlayNetworking.send(new ClientMessageCraft(this.selectedRecipe.method_8114(), this.field_2797.field_7763));
            }
        }));
    }

    private void addUrlButton() {
        this.method_37063(new class_344(field_2776 + 112, field_2800 + 164, 18, 18, 149, 211, 18, TEXTURE, b -> {
            if (this.selectedRecipe != null) {
                class_1799 output = selectedRecipe.getOutput();
                class_1792 item = output.method_7909();
                class_2960 id;
                if (item instanceof IGun iGun) {
                    id = iGun.getGunId(output);
                } else if (item instanceof IAttachment iAttachment) {
                    id = iAttachment.getAttachmentId(output);
                } else if (item instanceof IAmmo iAmmo) {
                    id = iAmmo.getAmmoId(output);
                } else {
                    return;
                }

                PackInfo packInfo = ClientAssetsManager.INSTANCE.getPackInfo(id);
                if (packInfo == null) {
                    return;
                }
                String url = packInfo.getUrl();
                if (StringUtils.isNotBlank(url) && field_22787 != null) {
                    field_22787.method_1507(new class_407(yes -> {
                        if (yes) {
                            class_156.method_668().method_670(url);
                        }
                        field_22787.method_1507(this);
                    }, url, false));
                }
            }
        }));
    }

    private void addIndexButtons() {
        if (selectedRecipeList == null || selectedRecipeList.isEmpty()) {
            return;
        }
        for (int i = 0; i < 6; i++) {
            int finalIndex = i + indexPage * 6;
            if (finalIndex >= selectedRecipeList.size()) {
                break;
            }
            int yOffset = field_2800 + 66 + 17 * i;
            class_2960 recipeId = selectedRecipeList.get(finalIndex);
            GunSmithTableRecipe recipe = getSelectedRecipe(recipeId);
            if (recipe == null) {
                continue;
            }
            ResultButton button = method_37063(new ResultButton(field_2776 + 144, yOffset, recipe.getOutput(), b -> {
                this.selectedRecipe = recipe;
                this.getPlayerIngredientCount(this.selectedRecipe);
                this.method_25426();
            }));
            if (this.selectedRecipe != null && recipe.method_8114().equals(this.selectedRecipe.method_8114())) {
                button.setSelected(true);
            }
        }
    }

    private void addTypeButtons() {
        var list = Arrays.asList(recipeKeys.values().toArray(new TabConfig[0]));
        for (int i = 0; i < 7; i++) {
            int typeIndex = typePage * 7 + i;
            if (typeIndex >= recipes.size()) {
                return;
            }
            TabConfig tabConfig = list.get(typeIndex);
            class_2960 type = tabConfig.id();
            int xOffset = field_2776 + 157 + 24 * i;

            class_1799 icon = tabConfig.icon();

            TypeButton typeButton = new TypeButton(xOffset, field_2800 + 2, icon, b -> {
                this.selectedType = type;
                this.selectedRecipeList = recipes.get(type);
                this.indexPage = 0;
                this.selectedRecipe = getSelectedRecipe(this.selectedRecipeList.isEmpty() ? null : this.selectedRecipeList.get(0));
                this.getPlayerIngredientCount(this.selectedRecipe);
                this.method_25426();
            });
            typeButton.method_47400(class_7919.method_47408(tabConfig.getName(), tabConfig.getName()));
            if (this.selectedType.equals(type)) {
                typeButton.setSelected(true);
            }
            this.method_37063(typeButton);
        }
    }

    private void addIndexPageButtons() {
        this.method_37063(new class_344(field_2776 + 143, field_2800 + 56, 96, 6, 40, 166, 6, TEXTURE, b -> {
            if (this.indexPage > 0) {
                this.indexPage--;
                this.method_25426();
            }
        }));
        this.method_37063(new class_344(field_2776 + 143, field_2800 + 171, 96, 6, 40, 186, 6, TEXTURE, b -> {
            if (selectedRecipeList != null && !selectedRecipeList.isEmpty()) {
                int maxIndexPage = (selectedRecipeList.size() - 1) / 6;
                if (this.indexPage < maxIndexPage) {
                    this.indexPage++;
                    this.method_25426();
                }
            }
        }));
    }

    private void addTypePageButtons() {
        this.method_37063(new class_344(field_2776 + 136, field_2800 + 4, 18, 20, 0, 162, 20, TEXTURE, b -> {
            if (this.typePage > 0) {
                this.typePage--;
                this.method_25426();
            }
        }));
        this.method_37063(new class_344(field_2776 + 327, field_2800 + 4, 18, 20, 20, 162, 20, TEXTURE, b -> {
            int maxIndexPage = (recipes.size() - 1) / 7;
            if (this.typePage < maxIndexPage) {
                this.typePage++;
                this.method_25426();
            }
        }));
    }

    private void addScaleButtons() {
        this.method_37063(new class_344(field_2776 + 5, field_2800 + 5, 10, 10, 188, 173, 10, TEXTURE, b -> {
            this.scale = Math.min(this.scale + 20, 200);
        }));
        this.method_37063(new class_344(field_2776 + 17, field_2800 + 5, 10, 10, 200, 173, 10, TEXTURE, b -> {
            this.scale = Math.max(this.scale - 20, 10);
        }));
        this.method_37063(new class_344(field_2776 + 29, field_2800 + 5, 10, 10, 212, 173, 10, TEXTURE, b -> {
            this.scale = 70;
        }));
    }

    @Override
    public boolean method_25401(double pMouseX, double pMouseY, double pDelta) {
        if (pMouseX > field_2776 + 143 && pMouseX < field_2776 + 143 + 94 && pMouseY > field_2800 + 66 && pMouseY < field_2800 + 66 + 85) {
            if (pDelta > 0) {
                this.indexPage = Math.max(0, this.indexPage - 1);
            } else {
                int maxIndexPage = (selectedRecipeList.size() - 1) / 6;
                this.indexPage = Math.min(maxIndexPage, this.indexPage + 1);
            }
            this.method_25426();
            return true;
        }
        return super.method_25401(pMouseX, pMouseY, pDelta);
    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float partialTick) {
        super.method_25394(graphics, mouseX, mouseY, partialTick);
        drawModCenteredString(graphics, field_22793, class_2561.method_43471("gui.tacz.gun_smith_table.preview"), field_2776 + 108, field_2800 + 5, 0x555555);
        if (selectedType != null) {
            var config = recipeKeys.get(selectedType);
            if (config != null) {
                graphics.method_51439(field_22793, config.getName(), field_2776 + 150, field_2800 + 32, 0x555555, false);
            }
        }
        graphics.method_51439(field_22793, class_2561.method_43471("gui.tacz.gun_smith_table.ingredient"), field_2776 + 254, field_2800 + 50, 0x555555, false);
        drawModCenteredString(graphics, field_22793, class_2561.method_43471("gui.tacz.gun_smith_table.craft"), field_2776 + 312, field_2800 + 167, 0xFFFFFF);
        if (!this.filterEnabled && this.selectedRecipe != null) {
            this.renderLeftModel(this.selectedRecipe);
            this.renderPackInfo(graphics, this.selectedRecipe);
            graphics.method_51439(field_22793, class_2561.method_43469("gui.tacz.gun_smith_table.count", this.selectedRecipe.getResult().getResult().method_7947()), field_2776 + 254, field_2800 + 140, 0x555555, false);
        }
        if (selectedRecipeList != null && !selectedRecipeList.isEmpty()) {
            renderIngredient(graphics);
        }

        ((ScreenAccessor) this).tacz$getRenderables().stream().filter(w -> w instanceof ResultButton)
                .forEach(w -> ((ResultButton) w).renderTooltips(stack -> graphics.method_51446(field_22793, stack, mouseX, mouseY)));
    }

    private void renderPackInfo(class_332 gui, GunSmithTableRecipe recipe) {
        class_1799 output = recipe.getOutput();
        class_1792 item = output.method_7909();
        class_2960 id;
        if (item instanceof IGun iGun) {
            id = iGun.getGunId(output);
        } else if (item instanceof IAttachment iAttachment) {
            id = iAttachment.getAttachmentId(output);
        } else if (item instanceof IAmmo iAmmo) {
            id = iAmmo.getAmmoId(output);
        } else {
            return;
        }

        PackInfo packInfo = ClientAssetsManager.INSTANCE.getPackInfo(id);
        class_4587 poseStack = gui.method_51448();
        if (packInfo != null) {
            poseStack.method_22903();
            poseStack.method_22905(0.75f, 0.75f, 1);
            class_2561 nameText = class_2561.method_43471(packInfo.getName());
            gui.method_51439(field_22793, nameText, (int) ((field_2776 + 6) / 0.75f), (int) ((field_2800 + 122) / 0.75f), class_124.field_1063.method_532(), false);
            poseStack.method_22909();

            poseStack.method_22903();
            poseStack.method_22905(0.5f, 0.5f, 1);

            int offsetX = (field_2776 + 6) * 2;
            int offsetY = (field_2800 + 123) * 2;
            int nameWidth = field_22793.method_27525(nameText);
            class_2561 ver = class_2561.method_43470("v" + packInfo.getVersion()).method_27692(class_124.field_1073);
            gui.method_51439(field_22793, ver, (int) (offsetX + nameWidth * 0.75f / 0.5f + 5), offsetY, class_124.field_1063.method_532(), false);
            offsetY += 14;

            String descKey = packInfo.getDescription();
            if (StringUtils.isNoneBlank(descKey)) {
                class_2561 desc = class_2561.method_43471(descKey);
                List<class_5481> split = field_22793.method_1728(desc, 245);
                for (class_5481 charSequence : split) {
                    gui.method_51430(field_22793, charSequence, offsetX, offsetY, class_124.field_1063.method_532(), false);
                    offsetY += field_22793.field_2000;
                }
                offsetY += 3;
            }

            gui.method_51439(field_22793, class_2561.method_43471("gui.tacz.gun_smith_table.license")
                            .method_10852(class_2561.method_43470(packInfo.getLicense()).method_27692(class_124.field_1063)),
                    offsetX, offsetY, class_124.field_1063.method_532(), false);
            offsetY += 12;

            List<String> authors = packInfo.getAuthors();
            if (!authors.isEmpty()) {
                gui.method_51439(field_22793, class_2561.method_43471("gui.tacz.gun_smith_table.authors")
                                .method_10852(class_2561.method_43470(StringUtils.join(authors, ", ")).method_27692(class_124.field_1063)),
                        offsetX, offsetY, class_124.field_1063.method_532(), false);
                offsetY += 12;
            }

            gui.method_51439(field_22793, class_2561.method_43471("gui.tacz.gun_smith_table.date")
                            .method_10852(class_2561.method_43470(packInfo.getDate()).method_27692(class_124.field_1063)),
                    offsetX, offsetY, class_124.field_1063.method_532(), false);

            poseStack.method_22909();
        } else {
            class_2960 recipeId = recipe.method_8114();
            gui.method_51439(field_22793, class_2561.method_43471("gui.tacz.gun_smith_table.error").method_27692(class_124.field_1079), field_2776 + 6, field_2800 + 122, 0xAF0000, false);
            gui.method_51439(field_22793, class_2561.method_43469("gui.tacz.gun_smith_table.error.id", recipeId.toString()).method_27692(class_124.field_1079), field_2776 + 6, field_2800 + 134, 0xFFFFFF, false);
            PackInfo errorPackInfo = ClientAssetsManager.INSTANCE.getPackInfo(id);
            if (errorPackInfo != null) {
                gui.method_51439(field_22793, class_2561.method_43471(errorPackInfo.getName()).method_27692(class_124.field_1079), field_2776 + 6, field_2800 + 146, 0xAF0000, false);
            }
        }
    }

    private void renderIngredient(class_332 gui) {
        if (this.selectedRecipe == null) {
            return;
        }
        List<GunSmithTableIngredient> inputs = this.selectedRecipe.getInputs();
        for (int i = 0; i < 6; i++) {
            for (int j = 0; j < 2; j++) {
                int index = i * 2 + j;
                if (index >= inputs.size()) {
                    return;
                }
                int offsetX = field_2776 + 254 + 45 * j;
                int offsetY = field_2800 + 62 + 17 * i;

                GunSmithTableIngredient smithTableIngredient = inputs.get(index);
                class_1856 ingredient = smithTableIngredient.getIngredient();

                class_1799[] items = ingredient.method_8105();
                int itemIndex = ((int) (System.currentTimeMillis() / 1_000)) % items.length;
                class_1799 item = items[itemIndex];

                gui.method_51445(item, offsetX, offsetY);

                class_4587 poseStack = gui.method_51448();
                poseStack.method_22903();

                poseStack.method_46416(0, 0, 200);
                poseStack.method_22905(0.5f, 0.5f, 1);
                int count = smithTableIngredient.getCount();
                if (class_310.method_1551().field_1724 != null && class_310.method_1551().field_1724.method_7337()) {
                    gui.method_51433(field_22793, String.format("%d/∞", count), (offsetX + 17) * 2, (offsetY + 10) * 2, 0xFFFFFF, false);
                } else {
                    int hasCount = 0;
                    if (playerIngredientCount != null && index < playerIngredientCount.size()) {
                        hasCount = playerIngredientCount.get(index);
                    }
                    int color = count <= hasCount ? 0xFFFFFF : 0xFF0000;
                    gui.method_51433(field_22793, String.format("%d/%d", count, hasCount), (offsetX + 17) * 2, (offsetY + 10) * 2, color, false);
                }


                poseStack.method_22909();
            }
        }
    }

    @SuppressWarnings("deprecation")
    private void renderLeftModel(GunSmithTableRecipe recipe) {
        // 先标记一下，渲染高模
        RenderDistance.markGuiRenderTimestamp();

        float rotationPeriod = 8f;
        int xPos = field_2776 + 60;
        int yPos = field_2800 + 50;
        int startX = field_2776 + 3;
        int startY = field_2800 + 16;
        int width = 128;
        int height = 99;
        float rotPitch = 15;

        class_1041 window = class_310.method_1551().method_22683();
        double windowGuiScale = window.method_4495();
        int scissorX = (int) (startX * windowGuiScale);
        int scissorY = (int) (window.method_4506() - ((startY + height) * windowGuiScale));
        int scissorW = (int) (width * windowGuiScale);
        int scissorH = (int) (height * windowGuiScale);
        RenderSystem.enableScissor(scissorX, scissorY, scissorW, scissorH);

        class_310.method_1551().method_1531().method_4619(class_1059.field_5275).method_4527(false, false);
        RenderSystem.setShaderTexture(0, class_1059.field_5275);
        RenderSystem.enableBlend();
        RenderSystem.blendFunc(GlStateManager.class_4535.SRC_ALPHA, GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA);
        RenderSystem.setShaderColor(1.0F, 1.0F, 1.0F, 1.0F);
        class_4587 posestack = RenderSystem.getModelViewStack();
        posestack.method_22903();
        posestack.method_46416(xPos, yPos, 200);
        posestack.method_22904(8.0D, 8.0D, 0.0D);
        posestack.method_22905(1.0F, -1.0F, 1.0F);
        posestack.method_22905(scale, scale, scale);
        float rot = (System.currentTimeMillis() % (int) (rotationPeriod * 1000)) * (360f / (rotationPeriod * 1000));
        posestack.method_22907(class_7833.field_40714.rotationDegrees(rotPitch));
        posestack.method_22907(class_7833.field_40716.rotationDegrees(rot));
        RenderSystem.applyModelViewMatrix();
        class_4587 tmpPose = new class_4587();
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        class_308.method_24210();

        class_310.method_1551().method_1480().method_23178(recipe.getOutput(), class_811.field_4319, 0xf000f0, class_4608.field_21444, tmpPose, bufferSource, null, 0);

        bufferSource.method_22993();
        RenderSystem.enableDepthTest();
        class_308.method_24211();
        posestack.method_22909();
        RenderSystem.applyModelViewMatrix();

        RenderSystem.disableScissor();
    }

    @Override
    protected void method_2388(@NotNull class_332 gui, int mouseX, int mouseY) {
    }

    @Override
    protected void method_2389(@NotNull class_332 gui, float partialTick, int mouseX, int mouseY) {
        this.method_25420(gui);
        gui.method_25302(SIDE, field_2776, field_2800, 0, 0, 134, 187);
        gui.method_25302(TEXTURE, field_2776 + 136, field_2800 + 27, 0, 0, 208, 160);
    }

    @Override
    public boolean method_25421() {
        return false;
    }
}
