package com.tacz.guns.compat.cloth.common;

import com.tacz.guns.config.common.GunConfig;
import me.shedaniel.clothconfig2.api.ConfigBuilder;
import me.shedaniel.clothconfig2.api.ConfigCategory;
import me.shedaniel.clothconfig2.api.ConfigEntryBuilder;
import net.minecraft.class_2561;

public class GunClothConfig {
    public static void init(ConfigBuilder root, ConfigEntryBuilder entryBuilder) {
        ConfigCategory gun = root.getOrCreateCategory(class_2561.method_43471("config.tacz.common.gun"));

        gun.addEntry(entryBuilder.startIntField(class_2561.method_43471("config.tacz.common.gun.default_gun_fire_sound_distance"), GunConfig.DEFAULT_GUN_FIRE_SOUND_DISTANCE.get())
                .setMin(0).setMax(Integer.MAX_VALUE).setDefaultValue(64).setTooltip(class_2561.method_43471("config.tacz.common.gun.default_gun_fire_sound_distance.desc"))
                .setSaveConsumer(GunConfig.DEFAULT_GUN_FIRE_SOUND_DISTANCE::set).build());

        gun.addEntry(entryBuilder.startIntField(class_2561.method_43471("config.tacz.common.gun.default_gun_silence_sound_distance"), GunConfig.DEFAULT_GUN_SILENCE_SOUND_DISTANCE.get())
                .setMin(0).setMax(Integer.MAX_VALUE).setDefaultValue(16).setTooltip(class_2561.method_43471("config.tacz.common.gun.default_gun_silence_sound_distance.desc"))
                .setSaveConsumer(GunConfig.DEFAULT_GUN_SILENCE_SOUND_DISTANCE::set).build());

        gun.addEntry(entryBuilder.startIntField(class_2561.method_43471("config.tacz.common.gun.default_gun_other_sound_distance"), GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE.get())
                .setMin(0).setMax(Integer.MAX_VALUE).setDefaultValue(16).setTooltip(class_2561.method_43471("config.tacz.common.gun.default_gun_other_sound_distance.desc"))
                .setSaveConsumer(GunConfig.DEFAULT_GUN_OTHER_SOUND_DISTANCE::set).build());

        gun.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("config.tacz.common.gun.creative_player_consume_ammo"), GunConfig.CREATIVE_PLAYER_CONSUME_AMMO.get())
                .setDefaultValue(true).setTooltip(class_2561.method_43471("config.tacz.common.gun.creative_player_consume_ammo.desc"))
                .setSaveConsumer(GunConfig.CREATIVE_PLAYER_CONSUME_AMMO::set).build());

        gun.addEntry(entryBuilder.startBooleanToggle(class_2561.method_43471("config.tacz.common.gun.auto_reload_when_respawn"), GunConfig.AUTO_RELOAD_WHEN_RESPAWN.get())
                .setDefaultValue(false).setTooltip(class_2561.method_43471("config.tacz.common.gun.auto_reload_when_respawn.desc"))
                .setSaveConsumer(GunConfig.AUTO_RELOAD_WHEN_RESPAWN::set).build());
    }
}
