package com.tacz.guns.compat.playeranimator.animation;

import cn.sh1rocu.tacz.mixin.accessor.MinecraftAccessor;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.client.resource.GunDisplayInstance;
import dev.kosmx.playerAnim.api.layered.modifier.AdjustmentModifier;
import dev.kosmx.playerAnim.core.util.Vec3f;
import java.util.Optional;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_310;
import net.minecraft.class_3532;
import net.minecraft.class_4050;

public class AdjustmentYRotModifier implements Function<String, Optional<AdjustmentModifier.PartModifier>> {
    private final class_1657 player;

    private AdjustmentYRotModifier(class_1657 player) {
        this.player = player;
    }

    @Override
    public Optional<AdjustmentModifier.PartModifier> apply(String partName) {
        class_310 mc = class_310.method_1551();
        if (player.equals(mc.field_1724) && mc.field_1755 != null) {
            return Optional.empty();
        }

        if (player.method_5854() != null && "body".equals(partName)) {
            return Optional.empty();
        }

        float partialTick = mc.method_1493() ? ((MinecraftAccessor) mc).tacz$getPausePartialTick() : mc.method_1488();
        float yBodyRot = class_3532.method_17821(partialTick, player.field_6220, player.field_6283);
        float yHeadRot = class_3532.method_17821(partialTick, player.field_6259, player.field_6241);
        float xRot = class_3532.method_16439(partialTick, player.field_6004, player.method_36455());

        float yaw = yHeadRot - yBodyRot;
        yaw = class_3532.method_15393(yaw);
        yaw = class_3532.method_15363(yaw, -85f, 85f);

        float pitch = class_3532.method_15393(xRot);

        return switch (partName) {
            case "body" -> {
                if (!player.method_5681() && player.method_18376() == class_4050.field_18079) {
                    yield Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(0, 0, -yaw * class_3532.field_29847), Vec3f.ZERO));
                }
                yield Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(0, -yaw * class_3532.field_29847, 0), Vec3f.ZERO));
            }
            case "head" ->
                    Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(pitch * class_3532.field_29847, 0, 0), Vec3f.ZERO));
            case "leftArm", "rightArm" -> {
                if (TimelessAPI.getGunDisplay(player.method_6047()).map(GunDisplayInstance::is3rdFixedHand).orElse(false)) {
                    yield Optional.empty();
                }
                yield Optional.of(new AdjustmentModifier.PartModifier(new Vec3f(pitch * class_3532.field_29847, 0, 0), Vec3f.ZERO));
            }
            default -> Optional.empty();
        };
    }

    public static AdjustmentModifier getModifier(class_1657 player) {
        return new AdjustmentModifier(new AdjustmentYRotModifier(player));
    }
}
