package com.tacz.guns.entity.shooter;

import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.config.sync.SyncConfig;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.ExtraMovementModifier;
import com.tacz.guns.resource.modifier.custom.WeightModifier;
import com.tacz.guns.resource.pojo.data.gun.MoveSpeed;
import java.util.UUID;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_5134;

public class LivingEntitySpeedModifier {
    private static final UUID EXTRA_SPEED_MODIFIER_UUID = UUID.fromString("4D5696AE-A7C5-C59C-80E9-2A2DC8373C46");
    private static final UUID WEIGHT_SPEED_MODIFIER_UUID = UUID.fromString("2CB6F5AD-C6D2-9D29-4E84-0856ACD47CDB");
    private final class_1309 shooter;
    private final ShooterDataHolder dataHolder;

    public LivingEntitySpeedModifier(class_1309 shooter, ShooterDataHolder dataHolder) {
        this.shooter = shooter;
        this.dataHolder = dataHolder;
    }

    public void updateSpeedModifier() {
        if (!shooter.method_5805()) return;

        class_1799 stack = shooter.method_6047();
        var speedModifier = shooter.method_6127().method_26842(class_5134.field_23719);
        if (speedModifier == null) return;

        if (stack.method_7909() instanceof AbstractGunItem) {
            // 处理重量带来的修正
            AttachmentCacheProperty cacheProperty = IGunOperator.fromLivingEntity(shooter).getCacheProperty();
            if (cacheProperty != null) {
                double weightFactor = SyncConfig.WEIGHT_SPEED_MULTIPLIER.get();
                if (weightFactor > 0) {
                    float targetSpeed = cacheProperty.getCache(WeightModifier.ID);
                    targetSpeed *= (float) -weightFactor;
                    class_1322 currentModifier = speedModifier.method_6199(WEIGHT_SPEED_MODIFIER_UUID);
                    if (currentModifier == null || currentModifier.method_6186() != targetSpeed) {
                        speedModifier.method_6200(WEIGHT_SPEED_MODIFIER_UUID);
                        speedModifier.method_26835(new class_1322(WEIGHT_SPEED_MODIFIER_UUID, "Gun Speed Modifier",
                                targetSpeed, class_1322.class_1323.field_6330));
                    }
                }

                MoveSpeed speed = cacheProperty.getCache(ExtraMovementModifier.ID);
                if (speed != null) {
                    double targetSpeed = getTargetSpeed(speed);
                    class_1322 currentModifier = speedModifier.method_6199(EXTRA_SPEED_MODIFIER_UUID);
                    if (currentModifier == null || currentModifier.method_6186() != targetSpeed) {
                        speedModifier.method_6200(EXTRA_SPEED_MODIFIER_UUID);
                        speedModifier.method_26835(new class_1322(EXTRA_SPEED_MODIFIER_UUID, "Extra Gun Speed Modifier",
                                targetSpeed, class_1322.class_1323.field_6331));
                    }
                }
            }
        } else {
            speedModifier.method_6200(WEIGHT_SPEED_MODIFIER_UUID);
            speedModifier.method_6200(EXTRA_SPEED_MODIFIER_UUID);
        }
    }

    private double getTargetSpeed(MoveSpeed moveSpeed) {
        if (dataHolder.reloadStateType.isReloading()) {
            return moveSpeed.getReloadMultiplier();
        }
        if (dataHolder.isAiming) {
            return moveSpeed.getAimMultiplier();
        }
        return moveSpeed.getBaseMultiplier();
    }

}
