package com.tacz.guns.entity.sync.core;

import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2481;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2494;
import net.minecraft.class_2497;
import net.minecraft.class_2503;
import net.minecraft.class_2516;
import net.minecraft.class_2519;
import net.minecraft.class_2520;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.nbt.*;
import java.util.UUID;

/**
 * Framework provided serializers used for creating a {@link SyncedDataKey}. This covers all
 * primitive types and common objects. You can create your custom serializer by implementing
 * {@link IDataSerializer}.
 * <p>
 * Author: MrCrayfish
 * Open source at <a href="https://github.com/MrCrayfish/Framework">Github</a> under LGPL License.
 */
public class Serializers {
    public static final IDataSerializer<Boolean> BOOLEAN = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, Boolean value) {
            buf.writeBoolean(value);
        }

        @Override
        public Boolean read(class_2540 buf) {
            return buf.readBoolean();
        }

        @Override
        public class_2520 write(Boolean value) {
            return class_2481.method_23234(value);
        }

        @Override
        public Boolean read(class_2520 tag) {
            return ((class_2481) tag).method_10698() != 0;
        }
    };

    public static final IDataSerializer<Byte> BYTE = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, Byte value) {
            buf.writeByte(value);
        }

        @Override
        public Byte read(class_2540 buf) {
            return buf.readByte();
        }

        @Override
        public class_2520 write(Byte value) {
            return class_2481.method_23233(value);
        }

        @Override
        public Byte read(class_2520 tag) {
            return ((class_2481) tag).method_10698();
        }
    };

    public static final IDataSerializer<Short> SHORT = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, Short value) {
            buf.writeShort(value);
        }

        @Override
        public Short read(class_2540 buf) {
            return buf.readShort();
        }

        @Override
        public class_2520 write(Short value) {
            return class_2516.method_23254(value);
        }

        @Override
        public Short read(class_2520 tag) {
            return ((class_2516) tag).method_10696();
        }
    };

    public static final IDataSerializer<Integer> INTEGER = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, Integer value) {
            buf.method_10804(value);
        }

        @Override
        public Integer read(class_2540 buf) {
            return buf.method_10816();
        }

        @Override
        public class_2520 write(Integer value) {
            return class_2497.method_23247(value);
        }

        @Override
        public Integer read(class_2520 tag) {
            return ((class_2497) tag).method_10701();
        }
    };

    public static final IDataSerializer<Long> LONG = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, Long value) {
            buf.writeLong(value);
        }

        @Override
        public Long read(class_2540 buf) {
            return buf.readLong();
        }

        @Override
        public class_2520 write(Long value) {
            return class_2503.method_23251(value);
        }

        @Override
        public Long read(class_2520 tag) {
            return ((class_2503) tag).method_10699();
        }
    };

    public static final IDataSerializer<Float> FLOAT = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, Float value) {
            buf.writeFloat(value);
        }

        @Override
        public Float read(class_2540 buf) {
            return buf.readFloat();
        }

        @Override
        public class_2520 write(Float value) {
            return class_2494.method_23244(value);
        }

        @Override
        public Float read(class_2520 tag) {
            return ((class_2494) tag).method_10700();
        }
    };

    public static final IDataSerializer<Double> DOUBLE = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, Double value) {
            buf.writeDouble(value);
        }

        @Override
        public Double read(class_2540 buf) {
            return buf.readDouble();
        }

        @Override
        public class_2520 write(Double value) {
            return class_2489.method_23241(value);
        }

        @Override
        public Double read(class_2520 tag) {
            return ((class_2489) tag).method_10697();
        }
    };

    public static final IDataSerializer<Character> CHARACTER = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, Character value) {
            buf.writeChar(value);
        }

        @Override
        public Character read(class_2540 buf) {
            return buf.readChar();
        }

        @Override
        public class_2520 write(Character value) {
            return class_2497.method_23247(value);
        }

        @Override
        public Character read(class_2520 tag) {
            return (char) ((class_2497) tag).method_10701();
        }
    };

    public static final IDataSerializer<String> STRING = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, String value) {
            buf.method_10814(value);
        }

        @Override
        public String read(class_2540 buf) {
            return buf.method_19772();
        }

        @Override
        public class_2520 write(String value) {
            return class_2519.method_23256(value);
        }

        @Override
        public String read(class_2520 tag) {
            return tag.method_10714();
        }
    };

    public static final IDataSerializer<class_2487> TAG_COMPOUND = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, class_2487 value) {
            buf.method_10794(value);
        }

        @Override
        public class_2487 read(class_2540 buf) {
            return buf.method_10798();
        }

        @Override
        public class_2520 write(class_2487 value) {
            return value;
        }

        @Override
        public class_2487 read(class_2520 tag) {
            return (class_2487) tag;
        }
    };

    public static final IDataSerializer<class_2338> BLOCK_POS = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, class_2338 value) {
            buf.method_10807(value);
        }

        @Override
        public class_2338 read(class_2540 buf) {
            return buf.method_10811();
        }

        @Override
        public class_2520 write(class_2338 value) {
            return class_2503.method_23251(value.method_10063());
        }

        @Override
        public class_2338 read(class_2520 tag) {
            return class_2338.method_10092(((class_2503) tag).method_10699());
        }
    };

    public static final IDataSerializer<UUID> UUID = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, UUID value) {
            buf.method_10797(value);
        }

        @Override
        public UUID read(class_2540 buf) {
            return buf.method_10790();
        }

        @Override
        public class_2520 write(UUID value) {
            class_2487 compound = new class_2487();
            compound.method_10544("Most", value.getMostSignificantBits());
            compound.method_10544("Least", value.getLeastSignificantBits());
            return compound;
        }

        @Override
        public UUID read(class_2520 tag) {
            class_2487 compound = (class_2487) tag;
            return new UUID(compound.method_10537("Most"), compound.method_10537("Least"));
        }
    };

    public static final IDataSerializer<class_1799> ITEM_STACK = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, class_1799 value) {
            buf.method_10793(value);
        }

        @Override
        public class_1799 read(class_2540 buf) {
            return buf.method_10819();
        }

        @Override
        public class_2520 write(class_1799 value) {
            return value.method_7953(new class_2487());
        }

        @Override
        public class_1799 read(class_2520 tag) {
            return class_1799.method_7915((class_2487) tag);
        }
    };

    public static final IDataSerializer<class_2960> RESOURCE_LOCATION = new IDataSerializer<>() {
        @Override
        public void write(class_2540 buf, class_2960 value) {
            buf.method_10812(value);
        }

        @Override
        public class_2960 read(class_2540 buf) {
            return buf.method_10810();
        }

        @Override
        public class_2520 write(class_2960 value) {
            return class_2519.method_23256(value.toString());
        }

        @Override
        public class_2960 read(class_2520 tag) {
            return class_2960.method_12829(tag.method_10714());
        }
    };
}
