package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import com.tacz.guns.entity.sync.core.DataEntry;
import com.tacz.guns.entity.sync.core.SyncedEntityData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import java.util.ArrayList;
import java.util.List;

public class ServerMessageUpdateEntityData implements FabricPacket {
    public static final PacketType<ServerMessageUpdateEntityData> TYPE = PacketType.create(new class_2960(GunMod.MOD_ID, "s2c_update_entity_data"), ServerMessageUpdateEntityData::new);

    private final int entityId;
    private final List<DataEntry<?, ?>> entries;

    private static List<DataEntry<?, ?>> readEntries(class_2540 buf) {
        int size = buf.method_10816();
        List<DataEntry<?, ?>> entries = new ArrayList<>();
        for (int i = 0; i < size; i++) {
            entries.add(DataEntry.read(buf));
        }
        return entries;
    }

    public ServerMessageUpdateEntityData(class_2540 buf) {
        this(buf.method_10816(), readEntries(buf));
    }

    public ServerMessageUpdateEntityData(int entityId, List<DataEntry<?, ?>> entries) {
        this.entityId = entityId;
        this.entries = entries;
    }

    @Override
    public void write(class_2540 buffer) {
        buffer.method_10804(entityId);
        buffer.method_10804(entries.size());
        entries.forEach(entry -> entry.write(buffer));
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    @Environment(EnvType.CLIENT)
    public void handle(class_746 player, PacketSender responseSender) {
        onHandle(this);
    }

    @Environment(EnvType.CLIENT)
    private static void onHandle(ServerMessageUpdateEntityData message) {
        class_1937 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        class_1297 entity = level.method_8469(message.entityId);
        if (entity == null) {
            return;
        }
        SyncedEntityData instance = SyncedEntityData.instance();
        message.entries.forEach(entry -> instance.set(entity, entry.getKey(), entry.getValue()));
    }
}
