package com.tacz.guns.network.message.handshake;

import com.tacz.guns.GunMod;
import com.tacz.guns.entity.sync.core.SyncedDataKey;
import com.tacz.guns.entity.sync.core.SyncedEntityData;
import com.tacz.guns.network.IHandshakeMessage;
import io.netty.util.concurrent.Future;
import io.netty.util.concurrent.GenericFutureListener;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_2535;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

import java.util.*;
import java.util.function.Consumer;

public class SyncedEntityDataMappingS2CPacket implements IHandshakeMessage {
    public static final PacketType<SyncedEntityDataMappingS2CPacket> TYPE = PacketType.create(new class_2960("tacz", "synced_entity_data_mapping"), SyncedEntityDataMappingS2CPacket::new);
    private static final Marker HANDSHAKE = MarkerFactory.getMarker("TACZ_HANDSHAKE");
    private Map<class_2960, List<Pair<class_2960, Integer>>> keyMap;

    public SyncedEntityDataMappingS2CPacket() {

    }

    public SyncedEntityDataMappingS2CPacket(class_2540 buf) {
        int size = buf.readInt();
        this.keyMap = new HashMap<>();

        for (int i = 0; i < size; ++i) {
            class_2960 classId = buf.method_10810();
            class_2960 keyId = buf.method_10810();
            int id = buf.method_10816();
            this.keyMap.computeIfAbsent(classId, (k) -> new ArrayList<>()).add(Pair.of(keyId, id));
        }

    }

    public void write(class_2540 buf) {
        Set<SyncedDataKey<?, ?>> keys = SyncedEntityData.instance().getKeys();
        buf.writeInt(keys.size());
        keys.forEach((key) -> {
            int id = SyncedEntityData.instance().getInternalId(key);
            buf.method_10812(key.classKey().id());
            buf.method_10812(key.id());
            buf.method_10804(id);
        });
    }

    public IHandshakeMessage.IResponsePacket handle(class_2535 connection, Consumer<GenericFutureListener<? extends Future<? super Void>>> listenerAdder) {
        GunMod.LOGGER.debug(HANDSHAKE, "Received synced key mappings from server");
        if (!SyncedEntityData.instance().updateMappings(this.keyMap)) {
            connection.method_10747(class_2561.method_43470("Connection closed - [TacZ] Received unknown synced data keys."));
        }

        return new AcknowledgeC2SPacket();
    }

    public PacketType<?> getType() {
        return TYPE;
    }
}
