package com.tacz.guns.resource.modifier.custom;

import com.google.gson.annotations.SerializedName;
import com.tacz.guns.api.GunProperties;
import com.tacz.guns.api.modifier.CacheValue;
import com.tacz.guns.api.modifier.IAttachmentModifier;
import com.tacz.guns.api.modifier.JsonProperty;
import com.tacz.guns.resource.CommonAssetsManager;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import com.tacz.guns.resource.pojo.data.attachment.Modifier;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import javax.annotation.Nullable;
import java.util.Collections;
import java.util.List;

public class WeightModifier implements IAttachmentModifier<Modifier, Float> {
    public static final String ID = GunProperties.WEIGHT.name();

    @Override
    public String getId() {
        return ID;
    }

    @Override
    @SuppressWarnings("deprecation")
    public JsonProperty<Modifier> readJson(String json) {
        Data data = CommonAssetsManager.GSON.fromJson(json, Data.class);
        Modifier weightModifier = data.getWeightModifier();
        // 兼容旧版本写法
        if (weightModifier == null) {
            weightModifier = new Modifier();
            weightModifier.setAddend(data.getWeightAddend());
        }
        return new WeightJsonProperty(weightModifier);
    }

    @Override
    public CacheValue<Float> initCache(class_1799 gunItem, GunData gunData) {
        return new CacheValue<>(gunData.getWeight());
    }

    @Override
    public void eval(List<Modifier> modifiers, CacheValue<Float> cache) {
        double eval = AttachmentPropertyManager.eval(modifiers, cache.getValue());
        cache.setValue((float) eval);
    }

    @Override
    public String getOptionalFields() {
        return "weight";
    }

    @Override
    @Environment(EnvType.CLIENT)
    public List<DiagramsData> getPropertyDiagramsData(class_1799 gunItem, GunData gunData, AttachmentCacheProperty cacheProperty) {
        float weight = gunData.getWeight();
        float modifiedValue = cacheProperty.<Float>getCache(WeightModifier.ID);
        float modifier = modifiedValue - weight;

        double percent = Math.min(weight / 20.0, 1);
        double modifierPercent = Math.min(modifier / 20.0, 1);

        String titleKey = "gui.tacz.gun_refit.property_diagrams.weight";
        String positivelyString = String.format("%.2fkg §c(+%.2f)", modifiedValue, modifier);
        String negativelyString = String.format("%.2fkg §a(%.2f)", modifiedValue, modifier);
        String defaultString = String.format("%.2fkg", modifiedValue);
        boolean positivelyBetter = false;

        DiagramsData diagramsData = new DiagramsData(percent, modifierPercent, modifier, titleKey, positivelyString, negativelyString, defaultString, positivelyBetter);
        return Collections.singletonList(diagramsData);
    }

    @Override
    @Environment(EnvType.CLIENT)
    public int getDiagramsDataSize() {
        return 1;
    }

    public static class WeightJsonProperty extends JsonProperty<Modifier> {
        public WeightJsonProperty(Modifier value) {
            super(value);
        }

        @Override
        public void initComponents() {
            Modifier value = this.getValue();
            float adsAddendTime = 0;
            if (value != null) {
                // 传入默认值 0.2 进行测试，看看最终结果差值
                double eval = AttachmentPropertyManager.eval(value, 0.2);
                adsAddendTime = (float) (eval - 0.2);
            }
            // 添加文本提示
            if (adsAddendTime > 0) {
                components.add(class_2561.method_43471("tooltip.tacz.attachment.weight.increase").method_27692(class_124.field_1061));
            } else if (adsAddendTime < 0) {
                components.add(class_2561.method_43471("tooltip.tacz.attachment.weight.decrease").method_27692(class_124.field_1060));
            }
        }
    }

    public static class Data {
        @Nullable
        @SerializedName("weight_modifier")
        private Modifier weightModifier;

        @SerializedName("weight")
        @Deprecated
        private float weightAddend = 0;

        @Nullable
        public Modifier getWeightModifier() {
            return weightModifier;
        }

        @Deprecated
        public float getWeightAddend() {
            return weightAddend;
        }
    }
}
