package cn.sh1rocu.tacz.api.event;

import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1297;
import net.minecraft.class_1937;

public class EntityJoinLevelEvent extends BaseEvent implements ICancellableEvent {
    private final class_1297 entity;
    private final class_1937 level;
    private final boolean loadedFromDisk;

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (final Callback callback : callbacks)
            callback.post(event);
    });

    public EntityJoinLevelEvent(class_1297 entity, class_1937 level) {
        this(entity, level, false);
    }

    public EntityJoinLevelEvent(class_1297 entity, class_1937 level, boolean loadedFromDisk) {
        this.entity = entity;
        this.level = level;
        this.loadedFromDisk = loadedFromDisk;
    }

    public class_1297 getEntity() {
        return entity;
    }

    public class_1937 getLevel() {
        return level;
    }

    public boolean loadedFromDisk() {
        return loadedFromDisk;
    }

    public interface Callback {
        void post(EntityJoinLevelEvent event);
    }
}