package cn.sh1rocu.tacz.mixin.client;

import cn.sh1rocu.tacz.api.event.PlaySoundSourceEvent;
import cn.sh1rocu.tacz.api.mixin.ChannelAccessHandleInjection;
import cn.sh1rocu.tacz.util.SoundConsumerStorage;
import org.jetbrains.annotations.Nullable;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

import java.util.function.Consumer;
import net.minecraft.class_1113;
import net.minecraft.class_1140;
import net.minecraft.class_4224;
import net.minecraft.class_4225;
import net.minecraft.class_4235;

// From kilt
@Mixin(class_4235.class_4236.class)
public abstract class ChannelAccessHandleMixin implements ChannelAccessHandleInjection {
    @Shadow
    @Nullable class_4224 channel;
    @Unique
    private class_4225.class_4105 tacz$pool;
    @Unique
    private class_1140 tacz$soundEngine;
    @Unique
    private class_1113 tacz$soundInstance;

    @Override
    public void tacz$setPool(class_4225.class_4105 pool) {
        this.tacz$pool = pool;
    }

    @Override
    public void tacz$setSoundEngine(class_1140 engine) {
        this.tacz$soundEngine = engine;
    }

    @Override
    public void tacz$setSoundInstance(class_1113 instance) {
        this.tacz$soundInstance = instance;
    }

    @Inject(method = "method_19737", at = @At(value = "INVOKE", target = "Ljava/util/function/Consumer;accept(Ljava/lang/Object;)V", shift = At.Shift.AFTER))
    private void tacz$callPlaySoundEvents(Consumer<class_4224> consumer, CallbackInfo ci) {
        if (this.channel != null && tacz$soundEngine != null && tacz$soundInstance != null && SoundConsumerStorage.soundConsumerChannels.remove(consumer)) {
            if (tacz$pool == class_4225.class_4105.field_18352) {
                PlaySoundSourceEvent.CALLBACK.invoker().post(new PlaySoundSourceEvent(tacz$soundEngine, tacz$soundInstance, this.channel));
            }
            // 暂时用不到
            /* else if (tacz$pool == Library.Pool.STREAMING) {
                PlayStreamingSourceEvent.CALLBACK.invoker().post(new PlayStreamingSourceEvent(tacz$soundEngine, tacz$soundInstance, this.channel));
            }*/
        }
    }
}