package cn.sh1rocu.tacz.util.itemhandler.entity;

import cn.sh1rocu.tacz.util.forge.LazyOptional;
import cn.sh1rocu.tacz.util.itemhandler.CombinedInvWrapper;
import cn.sh1rocu.tacz.util.itemhandler.IItemHandlerModifiable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1304;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;

public abstract class EntityEquipmentInvWrapper implements IItemHandlerModifiable {
    protected final class_1309 entity;

    protected final List<class_1304> slots;

    public EntityEquipmentInvWrapper(final class_1309 entity, final class_1304.class_1305 slotType) {
        this.entity = entity;

        final List<class_1304> slots = new ArrayList<class_1304>();

        for (final class_1304 slot : class_1304.values()) {
            if (slot.method_5925() == slotType) {
                slots.add(slot);
            }
        }

        this.slots = ImmutableList.copyOf(slots);
    }

    @Override
    public int getSlots() {
        return slots.size();
    }

    @Override
    public class_1799 getStackInSlot(final int slot) {
        return entity.method_6118(validateSlotIndex(slot));
    }

    @Override
    public class_1799 insertItem(final int slot, final class_1799 stack, final boolean simulate) {
        if (stack.method_7960())
            return class_1799.field_8037;

        final class_1304 equipmentSlot = validateSlotIndex(slot);

        final class_1799 existing = entity.method_6118(equipmentSlot);

        int limit = getStackLimit(slot, stack);

        if (!existing.method_7960()) {
            if (!class_1799.method_31577(stack, existing))
                return stack;

            limit -= existing.method_7947();
        }

        if (limit <= 0)
            return stack;

        boolean reachedLimit = stack.method_7947() > limit;

        if (!simulate) {
            if (existing.method_7960()) {
                entity.method_5673(equipmentSlot, reachedLimit ? stack.method_46651(limit) : stack);
            } else {
                existing.method_7933(reachedLimit ? limit : stack.method_7947());
            }
        }

        return reachedLimit ? stack.method_46651(stack.method_7947() - limit) : class_1799.field_8037;
    }

    @Override
    public class_1799 extractItem(final int slot, final int amount, final boolean simulate) {
        if (amount == 0)
            return class_1799.field_8037;

        final class_1304 equipmentSlot = validateSlotIndex(slot);

        final class_1799 existing = entity.method_6118(equipmentSlot);

        if (existing.method_7960())
            return class_1799.field_8037;

        final int toExtract = Math.min(amount, existing.method_7914());

        if (existing.method_7947() <= toExtract) {
            if (!simulate) {
                entity.method_5673(equipmentSlot, class_1799.field_8037);
            }

            return existing;
        } else {
            if (!simulate) {
                entity.method_5673(equipmentSlot, existing.method_46651(existing.method_7947() - toExtract));
            }

            return existing.method_46651(toExtract);
        }
    }

    @Override
    public int getSlotLimit(final int slot) {
        final class_1304 equipmentSlot = validateSlotIndex(slot);
        return equipmentSlot.method_5925() == class_1304.class_1305.field_6178 ? 1 : class_1792.field_49998;
    }

    protected int getStackLimit(final int slot, final class_1799 stack) {
        return Math.min(getSlotLimit(slot), stack.method_7914());
    }

    @Override
    public void setStackInSlot(final int slot, final class_1799 stack) {
        final class_1304 equipmentSlot = validateSlotIndex(slot);
        if (class_1799.method_7973(entity.method_6118(equipmentSlot), stack))
            return;
        entity.method_5673(equipmentSlot, stack);
    }

    @Override
    public boolean isItemValid(int slot, class_1799 stack) {
        return true;
    }

    protected class_1304 validateSlotIndex(final int slot) {
        if (slot < 0 || slot >= slots.size())
            throw new IllegalArgumentException("Slot " + slot + " not in valid range - [0," + slots.size() + ")");

        return slots.get(slot);
    }

    public static LazyOptional<IItemHandlerModifiable>[] create(class_1309 entity) {
        @SuppressWarnings("unchecked")
        LazyOptional<IItemHandlerModifiable>[] ret = new LazyOptional[3];
        ret[0] = LazyOptional.of(() -> new EntityHandsInvWrapper(entity));
        ret[1] = LazyOptional.of(() -> new EntityArmorInvWrapper(entity));
        ret[2] = LazyOptional.of(() -> new CombinedInvWrapper(ret[0].orElse(null), ret[1].orElse(null)));
        return ret;
    }
}