package com.tacz.guns.api.event.common;

import cn.sh1rocu.tacz.api.LogicalSide;
import cn.sh1rocu.tacz.api.event.BaseEvent;
import cn.sh1rocu.tacz.api.event.ICancellableEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.ApiStatus.Obsolete;

import javax.annotation.Nullable;
import java.util.Optional;

/**
 * 生物被枪械子弹伤害时触发的事件
 */
public class EntityHurtByGunEvent extends BaseEvent implements KubeJSGunEventPoster<EntityHurtByGunEvent> {
    protected final class_1297 bullet;
    protected @Nullable class_1297 hurtEntity;
    protected @Nullable class_1309 attacker;
    protected class_2960 gunId;
    protected class_2960 gunDisplayId;
    protected float baseAmount;
    protected class_1282 nonApPartDamageSource;
    protected class_1282 apPartDamageSource;
    protected boolean isHeadShot;
    protected float headshotMultiplier;
    protected final LogicalSide logicalSide;

    public static final Event<PreCallBack> PRE = EventFactory.createArrayBacked(PreCallBack.class, callbacks -> event -> {
        for (PreCallBack callback : callbacks) {
            callback.post(event);
        }
    });

    public static final Event<PostCallBack> POST = EventFactory.createArrayBacked(PostCallBack.class, callbacks -> event -> {
        for (PostCallBack callback : callbacks) {
            callback.post(event);
        }
    });

    public interface PreCallBack {
        void post(Pre event);
    }

    public interface PostCallBack {
        void post(Post event);
    }

    @ApiStatus.Internal
    protected EntityHurtByGunEvent(class_1297 bullet, @Nullable class_1297 hurtEntity, @Nullable class_1309 attacker,
                                   class_2960 gunId, class_2960 gunDisplayId,
                                   float baseAmount, @Nullable Pair<class_1282, class_1282> sources, boolean isHeadShot,
                                   float headshotMultiplier, LogicalSide logicalSide) {
        this.bullet = bullet;
        this.hurtEntity = hurtEntity;
        this.attacker = attacker;
        this.gunId = gunId;
        this.baseAmount = baseAmount;
        this.nonApPartDamageSource = Optional.ofNullable(sources).map(Pair::getLeft).orElse(null);
        this.apPartDamageSource = Optional.ofNullable(sources).map(Pair::getRight).orElse(null);
        this.isHeadShot = isHeadShot;
        this.headshotMultiplier = headshotMultiplier;
        this.logicalSide = logicalSide;
    }

    /**
     * 实体受到枪击，伤害判定前触发的事件，可以设置枪击的伤害属性
     */
    public static class Pre extends EntityHurtByGunEvent implements ICancellableEvent {
        @ApiStatus.Internal
        public Pre(class_1297 bullet, @Nullable class_1297 hurtEntity, @Nullable class_1309 attacker,
                   class_2960 gunId, class_2960 gunDisplayId,
                   float amount, @Nullable Pair<class_1282, class_1282> sources,
                   boolean isHeadShot, float headshotMultiplier, LogicalSide logicalSide) {
            super(bullet, hurtEntity, attacker, gunId, gunDisplayId, amount, sources, isHeadShot, headshotMultiplier, logicalSide);
            this.headshotMultiplier = headshotMultiplier;
            postEventToKubeJS(this);
        }

        public final void setHurtEntity(@Nullable class_1297 hurtEntity) {
            this.hurtEntity = hurtEntity;
        }

        public final void setAttacker(@Nullable class_1309 attacker) {
            this.attacker = attacker;
        }

        public final void setGunId(class_2960 gunId) {
            this.gunId = gunId;
        }

        public final void setBaseAmount(float baseAmount) {
            this.baseAmount = baseAmount;
        }

        public final void setDamageSource(GunDamageSourcePart part, class_1282 value) {
            if (logicalSide.isClient()) {
                throw new UnsupportedOperationException("DamageSource about gun hit is not available on client side!");
            }
            if (part == GunDamageSourcePart.ARMOR_PIERCING) {
                apPartDamageSource = value;
            } else {
                nonApPartDamageSource = value;
            }
        }

        public final void setHeadshot(boolean headshot) {
            this.isHeadShot = headshot;
        }

        public final void setHeadshotMultiplier(float headshotMultiplier) {
            this.headshotMultiplier = headshotMultiplier;
        }
    }

    /**
     * 实体受到枪击，伤害判定结束但没有死亡后触发的事件
     *
     * @see EntityKillByGunEvent 实体因枪击致死时触发的事件
     */
    public static class Post extends EntityHurtByGunEvent {
        @ApiStatus.Internal
        public Post(class_1297 bullet, @Nullable class_1297 hurtEntity, @Nullable class_1309 attacker,
                    class_2960 gunId, class_2960 gunDisplayId,
                    float amount, @Nullable Pair<class_1282, class_1282> sources,
                    boolean isHeadShot, float headshotMultiplier, LogicalSide logicalSide) {
            super(bullet, hurtEntity, attacker, gunId, gunDisplayId, amount, sources, isHeadShot, headshotMultiplier, logicalSide);
            postEventToKubeJS(this);
        }
    }

    public class_1297 getBullet() {
        return bullet;
    }

    @Nullable
    public class_1297 getHurtEntity() {
        return hurtEntity;
    }

    @Nullable
    public class_1309 getAttacker() {
        return attacker;
    }

    public class_2960 getGunId() {
        return gunId;
    }

    public class_2960 getGunDisplayId() {
        return gunDisplayId;
    }

    @Obsolete
    public float getAmount() {
        return baseAmount * headshotMultiplier;
    }

    public float getBaseAmount() {
        return baseAmount;
    }

    public class_1282 getDamageSource(GunDamageSourcePart part) {
        if (logicalSide.isClient()) {
            throw new UnsupportedOperationException("DamageSource about gun hit is not available on client side!");
        }
        return part == GunDamageSourcePart.ARMOR_PIERCING ? apPartDamageSource : nonApPartDamageSource;
    }

    public float getHeadshotMultiplier() {
        return headshotMultiplier;
    }

    public boolean isHeadShot() {
        return isHeadShot;
    }

    public LogicalSide getLogicalSide() {
        return logicalSide;
    }
}
