package com.tacz.guns.api.event.common;

import cn.sh1rocu.tacz.api.LogicalSide;
import cn.sh1rocu.tacz.api.event.BaseEvent;
import cn.sh1rocu.tacz.api.event.ICancellableEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

/**
 * 生物开始更换枪械弹药时触发的事件。
 */
public class GunReloadEvent extends BaseEvent implements KubeJSGunEventPoster<GunReloadEvent>, ICancellableEvent {
    private final class_1309 entity;
    private final class_1799 gunItemStack;
    private final LogicalSide logicalSide;

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.post(event);
        }
    });

    public interface Callback {
        void post(GunReloadEvent event);
    }

    public GunReloadEvent(class_1309 entity, class_1799 gunItemStack, LogicalSide side) {
        this.entity = entity;
        this.gunItemStack = gunItemStack;
        this.logicalSide = side;
        postEventToKubeJS(this);
    }

    public class_1309 getEntity() {
        return entity;
    }

    public class_1799 getGunItemStack() {
        return gunItemStack;
    }

    public LogicalSide getLogicalSide() {
        return logicalSide;
    }
}
