package com.tacz.guns.client.gui.components.refit;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.client.gui.GunRefitScreen;
import javax.annotation.Nonnull;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import java.util.Collections;
import java.util.List;
import java.util.function.Consumer;

public class RefitTurnPageButton extends class_4185 implements IComponentTooltip {
    private final boolean isUpPage;

    public RefitTurnPageButton(int pX, int pY, boolean isUpPage, class_4241 pOnPress) {
        super(pX, pY, 18, 8, class_2561.method_43473(), pOnPress, field_40754);
        this.isUpPage = isUpPage;
    }

    @Override
    public void method_48579(@Nonnull class_332 graphics, int pMouseX, int pMouseY, float pPartialTick) {
        RenderSystem.disableDepthTest();
        RenderSystem.enableBlend();

        int x = method_46426(), y = method_46427();
        int yOffset = isUpPage ? 0 : 80;
        if (method_25367()) {
            graphics.method_25293(GunRefitScreen.TURN_PAGE_TEXTURE, x, y, field_22758, field_22759, 0, yOffset, 180, 80, 180, 160);
        } else {
            graphics.method_25293(GunRefitScreen.TURN_PAGE_TEXTURE, x + 1, y + 1, field_22758 - 2, field_22759 - 2, 10, yOffset + 10, 180 - 20, 80 - 20, 180, 160);
        }

        RenderSystem.enableDepthTest();
        RenderSystem.disableBlend();
    }

    @Override
    public void renderTooltip(Consumer<List<class_2561>> consumer) {
        if (this.method_25367()) {
            String key = isUpPage ? "tooltip.tacz.page.previous" : "tooltip.tacz.page.next";
            consumer.accept(Collections.singletonList(class_2561.method_43471(key)));
        }
    }
}
