package com.tacz.guns.client.input;

import cn.sh1rocu.tacz.api.event.InputEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.config.util.InteractKeyConfigRead;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_3675;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_746;
import org.lwjgl.glfw.GLFW;

import static com.tacz.guns.util.InputExtraCheck.isInGame;

@Environment(EnvType.CLIENT)
public class InteractKey {
    public static final class_304 INTERACT_KEY = new class_304("key.tacz.interact.desc",
            class_3675.class_307.field_1668,
            GLFW.GLFW_KEY_O,
            "key.category.tacz");

    public static void onInteractKeyPress(InputEvent.Key event) {
        if (isInGame() && event.getAction() == GLFW.GLFW_PRESS && INTERACT_KEY.method_1417(event.getKey(), event.getScanCode())) {
            doInteractLogic();
        }
    }

    public static void onInteractMousePress(InputEvent.MouseButton.Post event) {
        if (isInGame() && event.getAction() == GLFW.GLFW_PRESS && INTERACT_KEY.method_1433(event.getButton())) {
            doInteractLogic();
        }
    }

    public static boolean onInteractControllerPress(boolean isPress) {
        if (isInGame() && isPress) {
            class_310 mc = class_310.method_1551();
            class_746 player = mc.field_1724;
            if (player == null || player.method_7325()) {
                return false;
            }
            if (!IGun.mainHandHoldGun(player)) {
                return false;
            }
            class_239 hitResult = mc.field_1765;
            if (hitResult == null) {
                return false;
            }
            if (hitResult instanceof class_3965 blockHitResult) {
                interactBlock(blockHitResult, player, mc);
                return true;
            }
            if (hitResult instanceof class_3966 entityHitResult) {
                interactEntity(entityHitResult, mc);
                return true;
            }
        }
        return false;
    }

    private static void doInteractLogic() {
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (player == null || player.method_7325()) {
            return;
        }
        if (!IGun.mainHandHoldGun(player)) {
            return;
        }
        class_239 hitResult = mc.field_1765;
        if (hitResult == null) {
            return;
        }
        if (hitResult instanceof class_3965 blockHitResult) {
            interactBlock(blockHitResult, player, mc);
            return;
        }
        if (hitResult instanceof class_3966 entityHitResult) {
            interactEntity(entityHitResult, mc);
        }
    }

    private static void interactBlock(class_3965 blockHitResult, class_746 player, class_310 mc) {
        class_2338 blockPos = blockHitResult.method_17777();
        class_2680 block = player.method_37908().method_8320(blockPos);
        if (InteractKeyConfigRead.canInteractBlock(block)) {
            mc.method_1583();
        }
    }

    private static void interactEntity(class_3966 entityHitResult, class_310 mc) {
        class_1297 entity = entityHitResult.method_17782();
        if (InteractKeyConfigRead.canInteractEntity(entity)) {
            mc.method_1583();
        }
    }
}