package com.tacz.guns.client.model.functional;

import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.model.BedrockAttachmentModel;
import com.tacz.guns.client.model.BedrockGunModel;
import com.tacz.guns.client.model.IFunctionalRenderer;
import com.tacz.guns.client.renderer.item.AttachmentItemRenderer;
import com.tacz.guns.util.RenderDistance;
import org.apache.commons.lang3.tuple.Pair;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

import java.util.EnumMap;
import net.minecraft.class_1047;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_811;

public class AttachmentRender implements IFunctionalRenderer {
    private final BedrockGunModel bedrockGunModel;
    private final AttachmentType type;

    public AttachmentRender(BedrockGunModel bedrockGunModel, AttachmentType type) {
        this.bedrockGunModel = bedrockGunModel;
        this.type = type;
    }

    public static void renderAttachment(class_1799 attachmentItem, class_1799 gunItem, class_4587 poseStack, class_811 transformType, int light, int overlay) {
        poseStack.method_22904(0, -1.5, 0);
        if (attachmentItem.method_7909() instanceof IAttachment iAttachment) {
            class_2960 attachmentId = iAttachment.getAttachmentId(attachmentItem);
            TimelessAPI.getClientAttachmentIndex(attachmentId).ifPresentOrElse(attachmentIndex -> {
                BedrockAttachmentModel model = attachmentIndex.getAttachmentModel();
                class_2960 texture = attachmentIndex.getModelTexture();
                // 这里是枪械里的配件渲染，没有模型材质就不渲染
                if (model != null && texture != null) {
                    // 调用低模
                    Pair<BedrockAttachmentModel, class_2960> lodModel = attachmentIndex.getLodModel();
                    // 有低模、在高模渲染范围外、不是第一人称
                    if (lodModel != null && !RenderDistance.inRenderHighPolyModelDistance(poseStack) && !transformType.method_29998()) {
                        model = lodModel.getLeft();
                        texture = lodModel.getRight();
                    }
                    class_1921 renderType = class_1921.method_23576(texture);
                    model.render(attachmentItem, gunItem, poseStack, transformType, renderType, light, overlay);
                }
            }, () -> {
                // 没有对应的 attachmentIndex，渲染黑紫材质以提醒
                class_4597 bufferSource = class_310.method_1551().method_22940().method_23000();
                class_4588 buffer = bufferSource.getBuffer(class_1921.method_23580(class_1047.method_4539()));
                AttachmentItemRenderer.SLOT_ATTACHMENT_MODEL.method_60879(poseStack, buffer, light, overlay);
            });
        }
    }

    @Override
    public void render(class_4587 poseStack, class_4588 vertexBuffer, class_811 transformType, int light, int overlay) {
        EnumMap<AttachmentType, class_1799> currentAttachmentItem = bedrockGunModel.getCurrentAttachmentItem();
        class_1799 attachmentItem = currentAttachmentItem.get(type);
        if (attachmentItem != null && !attachmentItem.method_7960()) {
            Matrix3f normal = new Matrix3f(poseStack.method_23760().method_23762());
            Matrix4f pose = new Matrix4f(poseStack.method_23760().method_23761());
            //和枪械模型共用顶点缓冲的都需要代理到渲染结束后渲染
            bedrockGunModel.delegateRender((poseStack1, vertexBuffer1, transformType1, light1, overlay1) -> {
                class_4587 poseStack2 = new class_4587();
                poseStack2.method_23760().method_23762().mul(normal);
                poseStack2.method_23760().method_23761().mul(pose);
                // 渲染配件
                renderAttachment(attachmentItem, bedrockGunModel.getCurrentGunItem(), poseStack2, transformType, light, overlay);
            });
        }
    }
}
