package cn.sh1rocu.tacz.mixin.common;

import cn.sh1rocu.tacz.api.event.EntityRemoveEvent;
import cn.sh1rocu.tacz.api.extension.IEntityPersistentData;
import net.minecraft.class_1297;
import net.minecraft.class_1937;
import net.minecraft.class_2487;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(class_1297.class)
public class EntityMixin implements IEntityPersistentData {
    @Shadow
    private class_1937 level;

    @Inject(method = "remove", at = @At("TAIL"))
    private void remove(class_1297.class_5529 reason, CallbackInfo ci) {
        if (!this.level.field_9236) {
            EntityRemoveEvent event = new EntityRemoveEvent((class_1297) (Object) this);
            EntityRemoveEvent.EVENT.invoker().onEntityRemove(event);
        }
    }

    @Unique
    private class_2487 tacz$persistentData;

    @Unique
    @Override
    public class_2487 tacz$getPersistentData() {
        if (this.tacz$persistentData == null) {
            this.tacz$persistentData = new class_2487();
        }
        return tacz$persistentData;
    }

    @Inject(method = "saveWithoutId", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;addAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"))
    private void tacz$savePersistentData(class_2487 nbt, CallbackInfoReturnable<class_2487> cir) {
        if (this.tacz$persistentData != null) {
            nbt.method_10566("ForgeData", this.tacz$persistentData.method_10553());
        }
    }

    @Inject(method = "save", at = @At("HEAD"))
    private void save(class_2487 nbt, CallbackInfoReturnable<class_2487> cir) {
        if (tacz$persistentData != null) {
            nbt.method_10566("ForgeData", tacz$persistentData);
        }
    }

    @Inject(method = "load", at = @At(value = "INVOKE", target = "Lnet/minecraft/world/entity/Entity;readAdditionalSaveData(Lnet/minecraft/nbt/CompoundTag;)V"))
    private void tacz$loadPersistentData(class_2487 nbt, CallbackInfo ci) {
        if (nbt.method_10573("ForgeData", 10)) {
            tacz$persistentData = nbt.method_10562("ForgeData");
        }
    }
}