package com.tacz.guns.api.item.nbt;

import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.api.item.IAttachment;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import java.util.Objects;

public interface AttachmentItemDataAccessor extends IAttachment {
    String ATTACHMENT_ID_TAG = "AttachmentId";
    String SKIN_ID_TAG = "Skin";
    String ZOOM_NUMBER_TAG = "ZoomNumber";
    String LASER_COLOR_TAG = "LaserColor";

    // 仅检查给定的 CompoundTag 是否具有配件 ID ，不校验其是否存在
    static boolean isAttachmentLike(class_2487 tag) {
        return tag.method_10573(ATTACHMENT_ID_TAG, class_2520.field_33258);
    }

    @Nonnull
    static class_2960 getAttachmentIdFromTag(@Nullable class_2487 nbt) {
        if (nbt == null) {
            return DefaultAssets.EMPTY_ATTACHMENT_ID;
        }
        if (isAttachmentLike(nbt)) {
            class_2960 attachmentId = class_2960.method_12829(nbt.method_10558(ATTACHMENT_ID_TAG));
            return Objects.requireNonNullElse(attachmentId, DefaultAssets.EMPTY_ATTACHMENT_ID);
        }
        return DefaultAssets.EMPTY_ATTACHMENT_ID;
    }

    static int getZoomNumberFromTag(@Nullable class_2487 nbt) {
        if (nbt == null) {
            return 0;
        }
        if (nbt.method_10573(ZOOM_NUMBER_TAG, class_2520.field_33253)) {
            return nbt.method_10550(ZOOM_NUMBER_TAG);
        }
        return 0;
    }

    static void setZoomNumberToTag(class_2487 nbt, int zoomNumber) {
        nbt.method_10569(ZOOM_NUMBER_TAG, zoomNumber);
    }

    @Override
    @Nonnull
    default class_2960 getAttachmentId(class_1799 attachmentStack) {
        class_2487 nbt = attachmentStack.method_7948();
        return getAttachmentIdFromTag(nbt);
    }

    @Override
    default void setAttachmentId(class_1799 attachmentStack, @Nullable class_2960 attachmentId) {
        class_2487 nbt = attachmentStack.method_7948();
        if (attachmentId != null) {
            nbt.method_10582(ATTACHMENT_ID_TAG, attachmentId.toString());
        }
    }

    @Override
    @Nullable
    default class_2960 getSkinId(class_1799 attachmentStack) {
        class_2487 nbt = attachmentStack.method_7948();
        if (nbt.method_10573(SKIN_ID_TAG, class_2520.field_33258)) {
            return class_2960.method_12829(nbt.method_10558(SKIN_ID_TAG));
        }
        return null;
    }

    @Override
    default void setSkinId(class_1799 attachmentStack, @Nullable class_2960 skinId) {
        class_2487 nbt = attachmentStack.method_7948();
        if (skinId != null) {
            nbt.method_10582(SKIN_ID_TAG, skinId.toString());
        } else {
            nbt.method_10551(SKIN_ID_TAG);
        }
    }

    @Override
    default int getZoomNumber(class_1799 attachmentStack) {
        class_2487 nbt = attachmentStack.method_7948();
        return getZoomNumberFromTag(nbt);
    }

    @Override
    default void setZoomNumber(class_1799 attachmentStack, int zoomNumber) {
        class_2487 nbt = attachmentStack.method_7948();
        setZoomNumberToTag(nbt, zoomNumber);
    }

    @Override
    default boolean hasCustomLaserColor(class_1799 attachmentStack) {
        class_2487 nbt = attachmentStack.method_7948();
        return nbt.method_10573(LASER_COLOR_TAG, class_2520.field_33253);
    }

    @Override
    default int getLaserColor(class_1799 attachmentStack) {
        class_2487 nbt = attachmentStack.method_7948();
        if (!hasCustomLaserColor(attachmentStack)) {
            return 0xFF0000;
        }
        return nbt.method_10550(LASER_COLOR_TAG);
    }

    @Override
    default void setLaserColor(class_1799 attachmentStack, int color) {
        class_2487 nbt = attachmentStack.method_7948();
        nbt.method_10569(LASER_COLOR_TAG, color);
    }
}
