package com.tacz.guns.client.gui.overlay;

import com.tacz.guns.GunMod;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.GunHeatData;
import java.text.DecimalFormat;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_746;

public class HeatBarOverlay {
    private static final class_2960 HEATBASE = new class_2960(GunMod.MOD_ID, "textures/hud/heat_base.png");
    private static final DecimalFormat HEAT_FORMAT_PERCENT = new DecimalFormat("0.0%");
    private static float heatScale = 0.25f;

    public static void render(class_332 graphics, float partialTick) {
        int width = graphics.method_51421();
        int height = graphics.method_51443();

        if (!RenderConfig.GUN_HUD_ENABLE.get()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (!(player instanceof IClientPlayerGunOperator)) {
            return;
        }
        class_1799 stack = player.method_6047();
        if (!(stack.method_7909() instanceof IGun iGun)) {
            return;
        }
        class_2960 gunId = iGun.getGunId(stack);
        GunData gunData = TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getGunData).orElse(null);
        GunDisplayInstance display = TimelessAPI.getGunDisplay(stack).orElse(null);
        if (gunData == null || display == null) {
            return;
        }

        class_4587 poseStack = graphics.method_51448();
        if (gunData.getHeatData() != null && iGun.hasHeatData(stack)) {
            poseStack.method_22903();
            GunHeatData heatData = gunData.getHeatData();
            float percent = iGun.getHeatAmount(stack) / heatData.getHeatMax();

            float scaleValue = ((iGun.getHeatAmount(stack) / heatData.getHeatMax()) / 8f) + 0.75f;

            if (heatScale < scaleValue) heatScale += 0.05f;
            if (heatScale > scaleValue) heatScale -= 0.025f;
            if (heatScale > scaleValue - 0.03 && heatScale < scaleValue + 0.055) heatScale = scaleValue;
            poseStack.method_22905(heatScale, heatScale, 1);

            boolean locked = iGun.isOverheatLocked(stack);
            int tickCount = mc.field_1705.method_1738();
            renderOverheat(percent, graphics, (int) (width / heatScale), (int) (height / heatScale), locked, tickCount);
            poseStack.method_22909();
        }
    }

    public static void renderOverheat(float heatPercentage, class_332 pGraphics, int w, int h,
                                      boolean locked, int tickCount) {
        int barColor = getHeatColor(heatPercentage, locked, tickCount);
        pGraphics.method_25294(w / 2 - 30, h / 2 + 30, w / 2 - 30 + (int) (heatPercentage * 60), h / 2 + 34, barColor);
        if (locked) {
            if (tickCount % 20 < 10) {
                pGraphics.method_51422(1, 0.1f, 0.1f, 1);
            } else {
                pGraphics.method_51422(1, 1, 0.1f, 1);
            }
        }
        pGraphics.method_25290(HEATBASE, w / 2 - 64, h / 2 - 44, 0, 0, 128, 128, 128, 128);
        pGraphics.method_51422(1, 1, 1, 1);

        class_327 font = class_310.method_1551().field_39924;
        String percentString = locked ? "!OVERHEAT!" : HEAT_FORMAT_PERCENT.format(heatPercentage);
        int color = locked ? (tickCount % 20 < 10 ? 0xFFFF0000 : 0xFFFFFF00) : 0xFFFFFFFF;

        pGraphics.method_51433(font, percentString, w / 2 - (font.method_1727(percentString) / 2), h / 2 + 38, color, true);
    }

    public static int getHeatColor(float percent, boolean locked, int tickCount) {
        if (locked) {
            return tickCount % 20 < 10 ? 0x9FFF0000 : 0x9FFFFF00;
        }
        if (percent < 0.4) return 0x9FFFFFFF;
        int color;
        if (percent <= 0.65) {
            color = class_5253.class_5254.method_48780(percent * 4 - 1.6f, 0x9FFFFFFF, 0x9FFFFF00);
        } else {
            color = class_5253.class_5254.method_48780((percent - 0.65f) / 0.35f, 0x9FFFFF00, 0x9FFF0000);
        }
        return color;
    }
}
