package com.tacz.guns.network.message;

import com.tacz.guns.GunMod;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.resource.modifier.AttachmentPropertyManager;
import net.fabricmc.fabric.api.networking.v1.FabricPacket;
import net.fabricmc.fabric.api.networking.v1.PacketSender;
import net.fabricmc.fabric.api.networking.v1.PacketType;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;

public class ClientMessageRefitGun implements FabricPacket {
    public static final PacketType<ClientMessageRefitGun> TYPE = PacketType.create(new class_2960(GunMod.MOD_ID, "c2s_player_refit"), ClientMessageRefitGun::new);

    private final int attachmentSlotIndex;
    private final int gunSlotIndex;
    private final AttachmentType attachmentType;

    public ClientMessageRefitGun(class_2540 buf) {
        this(buf.readInt(), buf.readInt(), buf.method_10818(AttachmentType.class));
    }

    public ClientMessageRefitGun(int attachmentSlotIndex, int gunSlotIndex, AttachmentType attachmentType) {
        this.attachmentSlotIndex = attachmentSlotIndex;
        this.gunSlotIndex = gunSlotIndex;
        this.attachmentType = attachmentType;
    }

    @Override
    public void write(class_2540 buf) {
        buf.writeInt(attachmentSlotIndex);
        buf.writeInt(gunSlotIndex);
        buf.method_10817(attachmentType);
    }

    @Override
    public PacketType<?> getType() {
        return TYPE;
    }

    public void handle(class_3222 player, PacketSender responseSender) {
        class_1661 inventory = player.method_31548();
        class_1799 attachmentItem = inventory.method_5438(attachmentSlotIndex);
        class_1799 gunItem = inventory.method_5438(gunSlotIndex);
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun != null) {
            if (iGun.allowAttachment(gunItem, attachmentItem)) {
                class_1799 oldAttachmentItem = iGun.getAttachment(gunItem, attachmentType);
                iGun.installAttachment(gunItem, attachmentItem);
                // 刷新配件数据
                AttachmentPropertyManager.postChangeEvent(player, gunItem);
                inventory.method_5447(attachmentSlotIndex, oldAttachmentItem);
                // 如果卸载的是扩容弹匣，吐出所有子弹
                if (attachmentType == AttachmentType.EXTENDED_MAG) {
                    iGun.dropAllAmmo(player, gunItem);
                }
                player.field_7498.method_7623();
                NetworkHandler.sendToClientPlayer(new ServerMessageRefreshRefitScreen(), player);
            }
        }
    }
}
