package com.tacz.guns.particles;

import com.mojang.brigadier.StringReader;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.tacz.guns.api.DefaultAssets;
import com.tacz.guns.init.ModParticles;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2396;
import net.minecraft.class_2540;
import net.minecraft.class_7923;

public class BulletHoleOption implements class_2394 {
    public static final Codec<BulletHoleOption> CODEC = RecordCodecBuilder.create(builder ->
            builder.group(Codec.INT.fieldOf("dir").forGetter(option -> option.direction.ordinal()),
                    Codec.LONG.fieldOf("pos").forGetter(option -> option.pos.method_10063()),
                    Codec.STRING.fieldOf("ammo_id").forGetter(option -> option.ammoId),
                    Codec.STRING.fieldOf("gun_id").forGetter(option -> option.gunId),
                    Codec.STRING.optionalFieldOf("gun_display_id", DefaultAssets.DEFAULT_GUN_DISPLAY_ID.toString()).forGetter(option -> option.gunDisplayId)
            ).apply(builder, BulletHoleOption::new));

    @SuppressWarnings("deprecation")
    public static final class_2394.class_2395<BulletHoleOption> DESERIALIZER = new class_2394.class_2395<>() {
        @Override
        public BulletHoleOption method_10296(class_2396<BulletHoleOption> particleType, StringReader reader) throws CommandSyntaxException {
            reader.expect(' ');
            int dir = reader.readInt();
            reader.expect(' ');
            long pos = reader.readLong();
            reader.expect(' ');
            String ammoId = reader.readString();
            reader.expect(' ');
            String gunId = reader.readString();
            reader.expect(' ');
            String gunDisplayId = reader.readString();
            return new BulletHoleOption(dir, pos, ammoId, gunId, gunDisplayId);
        }

        @Override
        public BulletHoleOption method_10297(class_2396<BulletHoleOption> particleType, class_2540 buffer) {
            return new BulletHoleOption(buffer.method_10816(), buffer.readLong(), buffer.method_19772(), buffer.method_19772(), buffer.method_19772());
        }
    };

    private final class_2350 direction;
    private final class_2338 pos;
    private final String ammoId;
    private final String gunId;
    private final String gunDisplayId;

    public BulletHoleOption(int dir, long pos, String ammoId, String gunId, String gunDisplayId) {
        this.direction = class_2350.values()[dir];
        this.pos = class_2338.method_10092(pos);
        this.ammoId = ammoId;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
    }

    public BulletHoleOption(class_2350 dir, class_2338 pos, String ammoId, String gunId, String gunDisplayId) {
        this.direction = dir;
        this.pos = pos;
        this.ammoId = ammoId;
        this.gunId = gunId;
        this.gunDisplayId = gunDisplayId;
    }

    public class_2350 getDirection() {
        return this.direction;
    }

    public class_2338 getPos() {
        return this.pos;
    }

    public String getAmmoId() {
        return ammoId;
    }

    public String getGunId() {
        return gunId;
    }

    public String getGunDisplayId() {
        return gunDisplayId;
    }

    @Override
    public class_2396<?> method_10295() {
        return ModParticles.BULLET_HOLE;
    }

    @Override
    public void method_10294(class_2540 buffer) {
        buffer.method_10817(this.direction);
        buffer.method_10807(this.pos);
        buffer.method_10814(this.ammoId);
        buffer.method_10814(this.gunId);
        buffer.method_10814(this.gunDisplayId);
    }

    @Override
    public String method_10293() {
        return class_7923.field_41180.method_10221(this.method_10295()) + " " + this.direction.method_10151();
    }
}
