package com.tacz.guns.api.event.common;

import cn.sh1rocu.tacz.api.LogicalSide;
import cn.sh1rocu.tacz.api.event.BaseEvent;
import cn.sh1rocu.tacz.api.event.ICancellableEvent;
import net.fabricmc.fabric.api.event.Event;
import net.fabricmc.fabric.api.event.EventFactory;
import net.minecraft.class_1309;
import net.minecraft.class_1799;

/**
 * 生物切换枪械开火模式时触发的事件
 */
public class GunFireSelectEvent extends BaseEvent implements KubeJSGunEventPoster<GunFireSelectEvent>, ICancellableEvent {
    private final class_1309 shooter;
    private final class_1799 gunItemStack;
    private final LogicalSide logicalSide;

    public static final Event<Callback> CALLBACK = EventFactory.createArrayBacked(Callback.class, callbacks -> event -> {
        for (Callback callback : callbacks) {
            callback.post(event);
        }
    });

    public interface Callback {
        void post(GunFireSelectEvent event);
    }

    public GunFireSelectEvent(class_1309 shooter, class_1799 gunItemStack, LogicalSide side) {
        this.shooter = shooter;
        this.gunItemStack = gunItemStack;
        this.logicalSide = side;
        postEventToKubeJS(this);
    }

    public class_1309 getShooter() {
        return shooter;
    }

    public class_1799 getGunItemStack() {
        return gunItemStack;
    }

    public LogicalSide getLogicalSide() {
        return logicalSide;
    }
}
