package com.tacz.guns.client.resource.manager;

import com.google.common.collect.Maps;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.client.animation.gltf.AnimationStructure;
import com.tacz.guns.client.resource.ClientAssetsManager;
import com.tacz.guns.client.resource.pojo.animation.gltf.RawAnimationStructure;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_7654;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

import java.io.IOException;
import java.io.Reader;
import java.util.Map;


public class GltfManager extends class_4080<Map<class_2960, AnimationStructure>> implements IdentifiableResourceReloadListener {
    private static final Marker MARKER = MarkerFactory.getMarker("GltfAnimationLoader");

    private final Map<class_2960, AnimationStructure> dataMap = Maps.newHashMap();
    private final class_7654 filetoidconverter = new class_7654("animations", ".gltf");

    @Override
    @NotNull
    protected Map<class_2960, AnimationStructure> method_18789(class_3300 pResourceManager, class_3695 pProfiler) {
        Map<class_2960, AnimationStructure> output = Maps.newHashMap();
        for (Map.Entry<class_2960, class_3298> entry : filetoidconverter.method_45113(pResourceManager).entrySet()) {
            class_2960 resourcelocation = entry.getKey();
            class_2960 resourcelocation1 = filetoidconverter.method_45115(resourcelocation);

            try (Reader reader = entry.getValue().method_43039()) {
                RawAnimationStructure rawStructure = ClientAssetsManager.GSON.fromJson(reader, RawAnimationStructure.class);
                AnimationStructure animationStructure = new AnimationStructure(rawStructure);
                output.put(resourcelocation1, animationStructure);
            } catch (IllegalArgumentException | IOException | JsonParseException jsonparseexception) {
                GunMod.LOGGER.warn(MARKER, "Failed to read gltf animation file: {}", resourcelocation);
            }
        }
        return output;
    }

    @Override
    protected void apply(Map<class_2960, AnimationStructure> pObject, class_3300 pResourceManager, class_3695 pProfiler) {
        dataMap.clear();
        dataMap.putAll(pObject);
    }

    public AnimationStructure getGltfAnimation(class_2960 id) {
        return dataMap.get(id);
    }

    public static final class_2960 ID = class_2960.method_60655(GunMod.MOD_ID, "gltf_manager");

    @Override
    public class_2960 getFabricId() {
        return ID;
    }
}
