package com.tacz.guns.item;

import cn.sh1rocu.tacz.api.extension.IItem;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.builder.BlockItemBuilder;
import com.tacz.guns.api.item.nbt.BlockItemDataAccessor;
import com.tacz.guns.client.renderer.item.GunSmithTableItemRenderer;
import com.tacz.guns.client.resource.index.ClientBlockIndex;
import com.tacz.guns.inventory.tooltip.BlockItemTooltip;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2248;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5632;
import net.minecraft.class_756;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nonnull;
import java.util.Optional;

public class GunSmithTableItem extends class_1747 implements BlockItemDataAccessor, IItem {
    public GunSmithTableItem(class_2248 block) {
        super(block, (new class_1792.class_1793()).method_7889(1));
    }

    @Environment(EnvType.CLIENT)
    @Override
    public class_756 getCustomRenderer() {
        return GunSmithTableItemRenderer.INSTANCE.get();
    }

    public static class_2371<class_1799> fillItemCategory() {
        class_2371<class_1799> stacks = class_2371.method_10211();
        TimelessAPI.getAllCommonBlockIndex().forEach((blockIndex) -> {
            class_1799 stack = BlockItemBuilder.create(blockIndex.getValue().getBlock()).setId(blockIndex.getKey()).build();
            stacks.add(stack);
        });
        return stacks;
    }

    @Override
    @Nonnull
    @Environment(EnvType.CLIENT)
    public class_2561 method_7864(@Nonnull class_1799 stack) {
        class_2960 blockId = this.getBlockId(stack);
        Optional<ClientBlockIndex> blockIndex = TimelessAPI.getClientBlockIndex(blockId);
        if (blockIndex.isPresent()) {
            return class_2561.method_43471(blockIndex.get().getName());
        }
        return super.method_7864(stack);
    }

//    @Override
//    @Environment(EnvType.CLIENT)
//    public void appendHoverText(ItemStack stack, @Nullable Level level, List<Component> components, TooltipFlag isAdvanced) {
//        ResourceLocation blockId = this.getBlockId(stack);
//        TimelessAPI.getClientBlockIndex(blockId).ifPresent(index -> {
//            String tooltipKey = index.getTooltipKey();
//            if (tooltipKey != null) {
//                components.add(Component.translatable(tooltipKey).withStyle(ChatFormatting.GRAY));
//            }
//        });
//
//        PackInfo packInfoObject = ClientAssetsManager.INSTANCE.getPackInfo(blockId);
//        if (packInfoObject != null) {
//            MutableComponent component = Component.translatable(packInfoObject.getName()).withStyle(ChatFormatting.BLUE).withStyle(ChatFormatting.ITALIC);
//            components.add(component);
//        }
//    }

    @Override
    @NotNull
    public Optional<class_5632> method_32346(class_1799 pStack) {
        return Optional.of(new BlockItemTooltip(this.getBlockId(pStack)));
    }
}
