package com.tacz.guns.network.message.event;

import cn.sh1rocu.tacz.api.LogicalSide;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.event.common.EntityKillByGunEvent;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_638;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

import javax.annotation.Nullable;

public record ServerMessageGunKill(int bulletId, int killEntityId, int attackerId, class_2960 gunId,
                                   class_2960 gunDisplayId, float baseDamage, boolean isHeadShot,
                                   float headshotMultiplier) implements class_8710 {
    public static final class_8710.class_9154<ServerMessageGunKill> TYPE = new class_8710.class_9154<>(
            class_2960.method_60655(GunMod.MOD_ID, "server_gun_kill")
    );
    public static final class_9139<class_9129, ServerMessageGunKill> STREAM_CODEC = class_9139.method_56437(
            ServerMessageGunKill::encode,
            ServerMessageGunKill::decode
    );

    @Override
    public @NotNull class_8710.class_9154<? extends class_8710> method_56479() {
        return TYPE;
    }

    public static void encode(class_9129 buf, ServerMessageGunKill message) {
        buf.method_53002(message.bulletId);
        buf.method_53002(message.killEntityId);
        buf.method_53002(message.attackerId);
        buf.method_10812(message.gunId);
        buf.method_10812(message.gunDisplayId);
        buf.method_52941(message.baseDamage);
        buf.method_52964(message.isHeadShot);
        buf.method_52941(message.headshotMultiplier);
    }

    public static ServerMessageGunKill decode(class_9129 buf) {
        int bulletId = buf.readInt();
        int killEntityId = buf.readInt();
        int attackerId = buf.readInt();
        class_2960 gunId = buf.method_10810();
        class_2960 gunDisplayId = buf.method_10810();
        float baseDamage = buf.readFloat();
        boolean isHeadShot = buf.readBoolean();
        float headshotMultiplier = buf.readFloat();
        return new ServerMessageGunKill(bulletId, killEntityId, attackerId, gunId, gunDisplayId, baseDamage, isHeadShot, headshotMultiplier);
    }

    public static void handle(ServerMessageGunKill message, ClientPlayNetworking.Context context) {
        context.client().execute(() -> onKill(message));
    }

    @Environment(EnvType.CLIENT)
    private static void onKill(ServerMessageGunKill message) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return;
        }
        @Nullable class_1297 bullet = level.method_8469(message.bulletId);
        @Nullable class_1309 killedEntity = level.method_8469(message.killEntityId) instanceof class_1309 livingEntity ? livingEntity : null;
        @Nullable class_1309 attacker = level.method_8469(message.attackerId) instanceof class_1309 livingEntity ? livingEntity : null;
        EntityKillByGunEvent.CALLBACK.invoker().post(new EntityKillByGunEvent(bullet, killedEntity, attacker, message.gunId, message.gunDisplayId, message.baseDamage, null, message.isHeadShot, message.headshotMultiplier, LogicalSide.CLIENT));
    }
}