package com.tacz.guns.resource.serialize;

import com.google.gson.*;
import java.lang.reflect.Type;
import net.minecraft.class_243;
import net.minecraft.class_3518;

public class Vec3Serializer implements JsonDeserializer<class_243>, JsonSerializer<class_243> {
    @Override
    public class_243 deserialize(JsonElement json, Type typeOfT, JsonDeserializationContext context) throws JsonParseException {
        if (json.isJsonArray()) {
            JsonArray array = json.getAsJsonArray();
            JsonElement xElement = array.get(0);
            JsonElement yElement = array.get(1);
            JsonElement zElement = array.get(2);
            double x = class_3518.method_34922(xElement, "(array i=0)");
            double y = class_3518.method_34922(yElement, "(array i=1)");
            double z = class_3518.method_34922(zElement, "(array i=2)");
            return new class_243(x, y, z);
        } else {
            throw new JsonSyntaxException("Expected " + json + " to be a Vec3 because it's not an array");
        }
    }

    @Override
    public JsonElement serialize(class_243 src, Type typeOfSrc, JsonSerializationContext context) {
        JsonArray array = new JsonArray(3);
        array.set(0, new JsonPrimitive(src.method_10216()));
        array.set(1, new JsonPrimitive(src.method_10214()));
        array.set(2, new JsonPrimitive(src.method_10215()));
        return array;
    }
}
