package com.tacz.guns.util;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonParseException;
import com.tacz.guns.GunMod;
import java.io.IOException;
import java.io.Reader;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2960;
import net.minecraft.class_3298;
import net.minecraft.class_3300;
import net.minecraft.class_3518;
import net.minecraft.class_7654;

public class ResourceScanner {
    /**
     * 扫描指定目录下的所有json文件<br>
     * 与原版的scanDirectory方法的区别在于，查询结果是作为返回值返回的，而且允许注释
     * 对于相同的文件路径，只读取优先级最高的文件
     *
     * @param pResourceManager 资源管理器
     * @param pName            目录名
     * @param pGson            Gson实例
     * @return 扫描到的json文件
     */
    public static Map<class_2960, JsonElement> scanDirectory(class_3300 pResourceManager, String pName, Gson pGson) {
        return scanDirectory(pResourceManager, class_7654.method_45114(pName), pGson);
    }

    public static Map<class_2960, JsonElement> scanDirectory(class_3300 pResourceManager, class_7654 filetoidconverter, Gson pGson) {
        Map<class_2960, JsonElement> output = Maps.newHashMap();
        for (Map.Entry<class_2960, class_3298> entry : filetoidconverter.method_45113(pResourceManager).entrySet()) {
            class_2960 resourcelocation = entry.getKey();
            class_2960 resourcelocation1 = filetoidconverter.method_45115(resourcelocation);

            try (Reader reader = entry.getValue().method_43039()) {
                JsonElement jsonelement = class_3518.method_15267(pGson, reader, JsonElement.class, true);
                JsonElement jsonelement1 = output.put(resourcelocation1, jsonelement);
                if (jsonelement1 != null) {
                    throw new IllegalStateException("Duplicate data file ignored with ID " + resourcelocation1);
                }
            } catch (IllegalArgumentException | IOException | JsonParseException jsonparseexception) {
                GunMod.LOGGER.error("Couldn't parse data file {} from {}", resourcelocation1, resourcelocation, jsonparseexception);
            }
        }
        return output;
    }

    /**
     * 扫描指定目录下的所有json文件<br/>
     * 与{@link #scanDirectory(class_3300, String, Gson)}不同的是，该方法会读取所有json文件作为列表返回
     *
     * @param pResourceManager  资源管理器
     * @param filetoidconverter 文件路径和id的映射
     * @param pGson             Gson实例
     * @return 扫描到的json文件
     */
    public static Map<class_2960, List<JsonElement>> scanDirectoryAll(class_3300 pResourceManager, class_7654 filetoidconverter, Gson pGson) {
        Map<class_2960, List<JsonElement>> output = Maps.newHashMap();
        for (Map.Entry<class_2960, List<class_3298>> entry : filetoidconverter.method_45116(pResourceManager).entrySet()) {
            class_2960 resourcelocation = entry.getKey();
            class_2960 resourcelocation1 = filetoidconverter.method_45115(resourcelocation);

            for (class_3298 resource : entry.getValue()) {
                try (Reader reader = resource.method_43039()) {
                    JsonElement jsonelement = class_3518.method_15267(pGson, reader, JsonElement.class, true);
                    List<JsonElement> list = output.computeIfAbsent(resourcelocation1, k -> Lists.newArrayList());
                    list.add(jsonelement);
                } catch (IllegalArgumentException | IOException | JsonParseException jsonparseexception) {
                    GunMod.LOGGER.error("Couldn't parse data file {} from {}", resourcelocation1, resourcelocation, jsonparseexception);
                }
            }
        }
        return output;
    }
}
