/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.api.client.animation.gltf.accessor;

import com.tacz.guns.api.client.animation.gltf.AccessorModel;
import com.tacz.guns.api.client.animation.gltf.BufferViewModel;
import com.tacz.guns.api.client.animation.gltf.GltfConstants;
import com.tacz.guns.api.client.animation.gltf.accessor.AccessorByteData;
import com.tacz.guns.api.client.animation.gltf.accessor.AccessorData;
import com.tacz.guns.api.client.animation.gltf.accessor.AccessorFloatData;
import com.tacz.guns.api.client.animation.gltf.accessor.AccessorIntData;
import com.tacz.guns.api.client.animation.gltf.accessor.AccessorShortData;
import com.tacz.guns.api.client.animation.gltf.accessor.NumberArrays;
import java.nio.ByteBuffer;
import java.util.Locale;

public class AccessorDatas {
    private AccessorDatas() {
    }

    public static AccessorData create(AccessorModel accessorModel) {
        BufferViewModel bufferViewModel = accessorModel.getBufferViewModel();
        ByteBuffer bufferViewData = bufferViewModel.getBufferViewData();
        return AccessorDatas.create(accessorModel, bufferViewData);
    }

    public static AccessorData create(AccessorModel accessorModel, ByteBuffer byteBuffer) {
        if (accessorModel.getComponentDataType() == Byte.TYPE) {
            return AccessorDatas.createByte(accessorModel, byteBuffer);
        }
        if (accessorModel.getComponentDataType() == Short.TYPE) {
            return AccessorDatas.createShort(accessorModel, byteBuffer);
        }
        if (accessorModel.getComponentDataType() == Integer.TYPE) {
            return AccessorDatas.createInt(accessorModel, byteBuffer);
        }
        if (accessorModel.getComponentDataType() == Float.TYPE) {
            return AccessorDatas.createFloat(accessorModel, byteBuffer);
        }
        return null;
    }

    public static AccessorData create(int componentType, ByteBuffer bufferViewData, int byteOffset, int count, int numComponentsPerElement, Integer byteStride) {
        if (AccessorDatas.isByteType(componentType)) {
            return new AccessorByteData(componentType, bufferViewData, byteOffset, count, numComponentsPerElement, byteStride);
        }
        if (AccessorDatas.isShortType(componentType)) {
            return new AccessorShortData(componentType, bufferViewData, byteOffset, count, numComponentsPerElement, byteStride);
        }
        if (AccessorDatas.isIntType(componentType)) {
            return new AccessorIntData(componentType, bufferViewData, byteOffset, count, numComponentsPerElement, byteStride);
        }
        if (AccessorDatas.isFloatType(componentType)) {
            return new AccessorFloatData(componentType, bufferViewData, byteOffset, count, numComponentsPerElement, byteStride);
        }
        throw new IllegalArgumentException("Not a valid component type: " + componentType);
    }

    public static boolean isByteType(int type) {
        return type == 5120 || type == 5121;
    }

    public static boolean isShortType(int type) {
        return type == 5122 || type == 5123;
    }

    public static boolean isIntType(int type) {
        return type == 5124 || type == 5125;
    }

    public static boolean isFloatType(int type) {
        return type == 5126;
    }

    static boolean isUnsignedType(int type) {
        return type == 5121 || type == 5123 || type == 5125;
    }

    static void validateByteType(int type) {
        if (!AccessorDatas.isByteType(type)) {
            throw new IllegalArgumentException("The type is not GL_BYTE or GL_UNSIGNED_BYTE, but " + GltfConstants.stringFor(type));
        }
    }

    static void validateShortType(int type) {
        if (!AccessorDatas.isShortType(type)) {
            throw new IllegalArgumentException("The type is not GL_SHORT or GL_UNSIGNED_SHORT, but " + GltfConstants.stringFor(type));
        }
    }

    static void validateIntType(int type) {
        if (!AccessorDatas.isIntType(type)) {
            throw new IllegalArgumentException("The type is not GL_INT or GL_UNSIGNED_INT, but " + GltfConstants.stringFor(type));
        }
    }

    static void validateFloatType(int type) {
        if (!AccessorDatas.isFloatType(type)) {
            throw new IllegalArgumentException("The type is not GL_FLOAT, but " + GltfConstants.stringFor(type));
        }
    }

    static AccessorByteData createByte(AccessorModel accessorModel) {
        BufferViewModel bufferViewModel = accessorModel.getBufferViewModel();
        return AccessorDatas.createByte(accessorModel, bufferViewModel.getBufferViewData());
    }

    private static AccessorByteData createByte(AccessorModel accessorModel, ByteBuffer bufferViewByteBuffer) {
        return new AccessorByteData(accessorModel.getComponentType(), bufferViewByteBuffer, accessorModel.getByteOffset(), accessorModel.getCount(), accessorModel.getElementType().getNumComponents(), accessorModel.getByteStride());
    }

    static AccessorShortData createShort(AccessorModel accessorModel) {
        BufferViewModel bufferViewModel = accessorModel.getBufferViewModel();
        return AccessorDatas.createShort(accessorModel, bufferViewModel.getBufferViewData());
    }

    private static AccessorShortData createShort(AccessorModel accessorModel, ByteBuffer bufferViewByteBuffer) {
        return new AccessorShortData(accessorModel.getComponentType(), bufferViewByteBuffer, accessorModel.getByteOffset(), accessorModel.getCount(), accessorModel.getElementType().getNumComponents(), accessorModel.getByteStride());
    }

    static AccessorIntData createInt(AccessorModel accessorModel) {
        BufferViewModel bufferViewModel = accessorModel.getBufferViewModel();
        return AccessorDatas.createInt(accessorModel, bufferViewModel.getBufferViewData());
    }

    private static AccessorIntData createInt(AccessorModel accessorModel, ByteBuffer bufferViewByteBuffer) {
        return new AccessorIntData(accessorModel.getComponentType(), bufferViewByteBuffer, accessorModel.getByteOffset(), accessorModel.getCount(), accessorModel.getElementType().getNumComponents(), accessorModel.getByteStride());
    }

    public static AccessorFloatData createFloat(AccessorModel accessorModel) {
        BufferViewModel bufferViewModel = accessorModel.getBufferViewModel();
        return AccessorDatas.createFloat(accessorModel, bufferViewModel.getBufferViewData());
    }

    private static AccessorFloatData createFloat(AccessorModel accessorModel, ByteBuffer bufferViewByteBuffer) {
        return new AccessorFloatData(accessorModel.getComponentType(), bufferViewByteBuffer, accessorModel.getByteOffset(), accessorModel.getCount(), accessorModel.getElementType().getNumComponents(), accessorModel.getByteStride());
    }

    static void validateCapacity(int byteOffset, int numElements, int byteStridePerElement, int bufferCapacity) {
        int expectedCapacity = numElements * byteStridePerElement;
        if (expectedCapacity > bufferCapacity) {
            throw new IllegalArgumentException("The accessorModel has an offset of " + byteOffset + " and " + numElements + " elements with a byte stride of " + byteStridePerElement + ", requiring " + expectedCapacity + " bytes, but the buffer view has only " + bufferCapacity + " bytes");
        }
    }

    public static Number[] computeMin(AccessorData accessorData) {
        if (accessorData instanceof AccessorByteData) {
            AccessorByteData accessorByteData = (AccessorByteData)accessorData;
            return NumberArrays.asNumbers(accessorByteData.computeMinInt());
        }
        if (accessorData instanceof AccessorShortData) {
            AccessorShortData accessorShortData = (AccessorShortData)accessorData;
            return NumberArrays.asNumbers(accessorShortData.computeMinInt());
        }
        if (accessorData instanceof AccessorIntData) {
            AccessorIntData accessorIntData = (AccessorIntData)accessorData;
            return NumberArrays.asNumbers(accessorIntData.computeMinLong());
        }
        if (accessorData instanceof AccessorFloatData) {
            AccessorFloatData accessorFloatData = (AccessorFloatData)accessorData;
            return NumberArrays.asNumbers(accessorFloatData.computeMin());
        }
        throw new IllegalArgumentException("Invalid data type: " + String.valueOf(accessorData));
    }

    public static Number[] computeMax(AccessorData accessorData) {
        if (accessorData instanceof AccessorByteData) {
            AccessorByteData accessorByteData = (AccessorByteData)accessorData;
            return NumberArrays.asNumbers(accessorByteData.computeMaxInt());
        }
        if (accessorData instanceof AccessorShortData) {
            AccessorShortData accessorShortData = (AccessorShortData)accessorData;
            return NumberArrays.asNumbers(accessorShortData.computeMaxInt());
        }
        if (accessorData instanceof AccessorIntData) {
            AccessorIntData accessorIntData = (AccessorIntData)accessorData;
            return NumberArrays.asNumbers(accessorIntData.computeMaxLong());
        }
        if (accessorData instanceof AccessorFloatData) {
            AccessorFloatData accessorFloatData = (AccessorFloatData)accessorData;
            return NumberArrays.asNumbers(accessorFloatData.computeMax());
        }
        throw new IllegalArgumentException("Invalid data type: " + String.valueOf(accessorData));
    }

    public static String createString(AccessorData accessorData, int elementsPerRow) {
        if (accessorData instanceof AccessorByteData) {
            AccessorByteData accessorByteData = (AccessorByteData)accessorData;
            String accessorDataString = accessorByteData.createString(Locale.ENGLISH, "%4d", elementsPerRow);
            return accessorDataString;
        }
        if (accessorData instanceof AccessorShortData) {
            AccessorShortData accessorShortData = (AccessorShortData)accessorData;
            String accessorDataString = accessorShortData.createString(Locale.ENGLISH, "%6d", elementsPerRow);
            return accessorDataString;
        }
        if (accessorData instanceof AccessorIntData) {
            AccessorIntData accessorIntData = (AccessorIntData)accessorData;
            String accessorDataString = accessorIntData.createString(Locale.ENGLISH, "%11d", elementsPerRow);
            return accessorDataString;
        }
        if (accessorData instanceof AccessorFloatData) {
            AccessorFloatData accessorFloatData = (AccessorFloatData)accessorData;
            String accessorDataString = accessorFloatData.createString(Locale.ENGLISH, "%10.5f", elementsPerRow);
            return accessorDataString;
        }
        return "Unknown accessor data type: " + String.valueOf(accessorData);
    }
}

