/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.client.gameplay;

import cn.sh1rocu.tacz.api.LogicalSide;
import cn.sh1rocu.tacz.mixin.accessor.BlockableEventLoopAccessor;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.animation.statemachine.LuaAnimationStateMachine;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ShootResult;
import com.tacz.guns.api.event.common.GunFireEvent;
import com.tacz.guns.api.event.common.GunShootEvent;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.animation.statemachine.GunAnimationStateContext;
import com.tacz.guns.client.gameplay.LocalPlayerDataHolder;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.message.ClientMessagePlayerShoot;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.modifier.AttachmentCacheProperty;
import com.tacz.guns.resource.modifier.custom.SilenceModifier;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.sound.SoundManager;
import it.unimi.dsi.fastutil.Pair;
import java.util.Optional;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Predicate;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_746;
import net.minecraft.class_8710;

public class LocalPlayerShoot {
    private static final Predicate<IGunOperator> SHOOT_LOCKED_CONDITION = operator -> operator.getSynShootCoolDown() > 0L;
    private final LocalPlayerDataHolder data;
    private final class_746 player;

    public LocalPlayerShoot(LocalPlayerDataHolder data, class_746 player) {
        this.data = data;
        this.player = player;
    }

    public ShootResult shoot() {
        boolean noAmmo;
        if (System.currentTimeMillis() - LocalPlayerDataHolder.clientClickButtonTimestamp < 50L) {
            return ShootResult.COOL_DOWN;
        }
        if (!this.data.isShootRecorded) {
            return ShootResult.COOL_DOWN;
        }
        if (this.data.clientStateLock && this.data.lockedCondition != SHOOT_LOCKED_CONDITION && this.data.lockedCondition != null) {
            this.data.isShootRecorded = true;
            return ShootResult.IS_DRAWING;
        }
        class_1799 mainHandItem = this.player.method_6047();
        class_1792 class_17922 = mainHandItem.method_7909();
        if (!(class_17922 instanceof IGun)) {
            return ShootResult.NOT_GUN;
        }
        IGun iGun = (IGun)class_17922;
        class_2960 gunId = iGun.getGunId(mainHandItem);
        Optional<ClientGunIndex> gunIndexOptional = TimelessAPI.getClientGunIndex(gunId);
        GunDisplayInstance display = TimelessAPI.getGunDisplay(mainHandItem).orElse(null);
        if (gunIndexOptional.isEmpty() || display == null) {
            return ShootResult.ID_NOT_EXIST;
        }
        ClientGunIndex gunIndex = gunIndexOptional.get();
        GunData gunData = gunIndex.getGunData();
        long coolDown = this.getCoolDown(iGun, mainHandItem, gunData);
        if (coolDown >= 50L) {
            return ShootResult.COOL_DOWN;
        }
        IGunOperator gunOperator = IGunOperator.fromLivingEntity((class_1309)this.player);
        if (gunOperator.getSynReloadState().getStateType().isReloading()) {
            return ShootResult.IS_RELOADING;
        }
        if (gunOperator.getSynDrawCoolDown() != 0L) {
            return ShootResult.IS_DRAWING;
        }
        if (gunOperator.getSynIsBolting()) {
            return ShootResult.IS_BOLTING;
        }
        if (gunOperator.getSynMeleeCoolDown() != 0L) {
            return ShootResult.IS_MELEE;
        }
        Bolt boltType = gunIndex.getGunData().getBolt();
        boolean useInventoryAmmo = iGun.useInventoryAmmo(mainHandItem);
        boolean hasAmmoInBarrel = iGun.hasBulletInBarrel(mainHandItem) && boltType != Bolt.OPEN_BOLT;
        boolean hasInventoryAmmo = iGun.hasInventoryAmmo((class_1309)this.player, mainHandItem, gunOperator.needCheckAmmo()) || hasAmmoInBarrel;
        int ammoCount = iGun.getCurrentAmmoCount(mainHandItem) + (hasAmmoInBarrel ? 1 : 0);
        boolean bl = noAmmo = useInventoryAmmo && !hasInventoryAmmo || !useInventoryAmmo && ammoCount < 1;
        if (noAmmo) {
            SoundPlayManager.playDryFireSound((class_1309)this.player, display);
            return ShootResult.NO_AMMO;
        }
        if (gunData.hasHeatData() && iGun.isOverheatLocked(mainHandItem)) {
            SoundPlayManager.playDryFireSound((class_1309)this.player, display);
            return ShootResult.OVERHEATED;
        }
        if (boltType == Bolt.MANUAL_ACTION && !hasAmmoInBarrel) {
            IClientPlayerGunOperator.fromLocalPlayer(this.player).bolt();
            return ShootResult.NEED_BOLT;
        }
        if (gunOperator.getSynSprintTime() > 0.0f) {
            return ShootResult.IS_SPRINTING;
        }
        GunShootEvent gunShootEvent = new GunShootEvent((class_1309)this.player, mainHandItem, LogicalSide.CLIENT);
        ((GunShootEvent.Callback)GunShootEvent.CALLBACK.invoker()).post(gunShootEvent);
        if (gunShootEvent.isCanceled()) {
            return ShootResult.FORGE_EVENT_CANCEL;
        }
        this.data.lockState(SHOOT_LOCKED_CONDITION);
        this.data.isShootRecorded = false;
        this.doShoot(display, iGun, mainHandItem, gunData, coolDown);
        return ShootResult.SUCCESS;
    }

    private void doShoot(GunDisplayInstance display, IGun iGun, class_1799 mainHandItem, GunData gunData, long delay) {
        boolean hasAmmoInBarrel;
        FireMode fireMode = iGun.getFireMode(mainHandItem);
        Bolt boltType = gunData.getBolt();
        boolean consumeAmmo = IGunOperator.fromLivingEntity((class_1309)this.player).consumesAmmoOrNot();
        boolean bl = hasAmmoInBarrel = iGun.hasBulletInBarrel(mainHandItem) && boltType != Bolt.OPEN_BOLT;
        int ammoCount = consumeAmmo ? iGun.getCurrentAmmoCount(mainHandItem) + (hasAmmoInBarrel ? 1 : 0) : Integer.MAX_VALUE;
        long period = fireMode == FireMode.BURST ? gunData.getBurstShootInterval() : 1L;
        int maxCount = Math.min(ammoCount, fireMode == FireMode.BURST ? gunData.getBurstData().getCount() : 1);
        AtomicInteger count = new AtomicInteger(0);
        LocalPlayerDataHolder.SCHEDULED_EXECUTOR_SERVICE.scheduleAtFixedRate(() -> {
            if (count.get() == 0) {
                this.data.isShootRecorded = true;
            }
            if (gunData.hasHeatData() && iGun.isOverheatLocked(mainHandItem)) {
                ScheduledFuture future = (ScheduledFuture)((Object)Thread.currentThread());
                future.cancel(false);
                return;
            }
            if (count.get() >= maxCount || this.player.method_29504()) {
                ScheduledFuture future = (ScheduledFuture)((Object)Thread.currentThread());
                future.cancel(false);
                return;
            }
            if (count.get() == 0) {
                if (this.data.clientStateLock && this.data.lockedCondition != SHOOT_LOCKED_CONDITION && this.data.lockedCondition != null) {
                    return;
                }
                this.data.clientLastShootTimestamp = this.data.clientShootTimestamp;
                this.data.clientShootTimestamp = System.currentTimeMillis();
                ClientPlayNetworking.send((class_8710)new ClientMessagePlayerShoot(this.data.clientShootTimestamp - this.data.clientBaseTimestamp));
            }
            ((BlockableEventLoopAccessor)class_310.method_1551()).tacz$submitAsync(() -> {
                boolean fire;
                GunFireEvent gunFireEvent = new GunFireEvent((class_1309)this.player, mainHandItem, LogicalSide.CLIENT);
                ((GunFireEvent.Callback)GunFireEvent.CALLBACK.invoker()).post(gunFireEvent);
                boolean bl = fire = !gunFireEvent.isCanceled();
                if (fire) {
                    LuaAnimationStateMachine<GunAnimationStateContext> animationStateMachine = display.getAnimationStateMachine();
                    if (animationStateMachine != null) {
                        animationStateMachine.trigger("shoot");
                    }
                    boolean useSilenceSound = this.useSilenceSound();
                    SoundPlayManager.stopPlayGunSound(display, SoundManager.INSPECT_SOUND);
                    if (useSilenceSound) {
                        SoundPlayManager.playSilenceSound((class_1309)this.player, display, gunData);
                    } else {
                        SoundPlayManager.playShootSound((class_1309)this.player, display, gunData);
                    }
                }
            });
            count.getAndIncrement();
        }, delay, period, TimeUnit.MILLISECONDS);
    }

    private boolean useSilenceSound() {
        AttachmentCacheProperty cacheProperty = IGunOperator.fromLivingEntity((class_1309)this.player).getCacheProperty();
        if (cacheProperty != null) {
            Pair silence = (Pair)cacheProperty.getCache(SilenceModifier.ID);
            return (Boolean)silence.right();
        }
        return false;
    }

    private long getCoolDown(IGun iGun, class_1799 mainHandItem, GunData gunData) {
        FireMode fireMode = iGun.getFireMode(mainHandItem);
        long coolDown = fireMode == FireMode.BURST ? (long)(gunData.getBurstData().getMinInterval() * 1000.0) - (System.currentTimeMillis() - this.data.clientShootTimestamp) : gunData.getShootInterval((class_1309)this.player, fireMode, mainHandItem) - (System.currentTimeMillis() - this.data.clientShootTimestamp);
        return Math.max(coolDown, 0L);
    }

    public long getClientShootCoolDown() {
        class_1799 mainHandItem = this.player.method_6047();
        IGun iGun = IGun.getIGunOrNull(mainHandItem);
        if (iGun == null) {
            return -1L;
        }
        class_2960 gunId = iGun.getGunId(mainHandItem);
        Optional<CommonGunIndex> gunIndexOptional = TimelessAPI.getCommonGunIndex(gunId);
        return gunIndexOptional.map(commonGunIndex -> this.getCoolDown(iGun, mainHandItem, commonGunIndex.getGunData())).orElse(-1L);
    }
}

