/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.compat.jei.entry;

import com.google.common.collect.Lists;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.item.GunTabType;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.builder.AttachmentItemBuilder;
import com.tacz.guns.api.item.builder.GunItemBuilder;
import com.tacz.guns.resource.index.CommonAttachmentIndex;
import com.tacz.guns.resource.index.CommonGunIndex;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;

public class AttachmentQueryEntry {
    private final class_1799 attachmentStack;
    private List<class_1799> allowGunStacks;
    private List<class_1799> extraAllowGunStacks;

    public AttachmentQueryEntry(class_2960 attachmentId, GunTabType type) {
        this.attachmentStack = AttachmentItemBuilder.create().setId(attachmentId).build();
        this.allowGunStacks = Lists.newArrayList();
        this.extraAllowGunStacks = Lists.newArrayList();
        this.addAllAllowGuns(type);
        this.dividedGuns();
    }

    public static List<AttachmentQueryEntry> getAllAttachmentQueryEntries() {
        ArrayList entries = Lists.newArrayList();
        TimelessAPI.getAllCommonAttachmentIndex().forEach(entry -> {
            if (((CommonAttachmentIndex)entry.getValue()).getPojo().isHidden()) {
                return;
            }
            for (GunTabType tabType : GunTabType.values()) {
                AttachmentQueryEntry queryEntry = new AttachmentQueryEntry((class_2960)entry.getKey(), tabType);
                if (queryEntry.getAllowGunStacks().isEmpty()) continue;
                entries.add(queryEntry);
            }
        });
        return entries;
    }

    public class_1799 getAttachmentStack() {
        return this.attachmentStack;
    }

    public List<class_1799> getAllowGunStacks() {
        return this.allowGunStacks;
    }

    public List<class_1799> getExtraAllowGunStacks() {
        return this.extraAllowGunStacks;
    }

    private void addAllAllowGuns(GunTabType type) {
        TimelessAPI.getAllCommonGunIndex().forEach(entry -> {
            String gunType;
            String tabType = type.name().toLowerCase(Locale.US);
            if (tabType.equals(gunType = ((CommonGunIndex)entry.getValue()).getType())) {
                class_1799 gun = GunItemBuilder.create().setId((class_2960)entry.getKey()).build((class_7225.class_7874)class_5455.method_40302((class_2378)class_7923.field_41167));
                class_1792 patt0$temp = gun.method_7909();
                if (!(patt0$temp instanceof IGun)) {
                    return;
                }
                IGun iGun = (IGun)patt0$temp;
                if (iGun.allowAttachment(gun, this.attachmentStack)) {
                    this.allowGunStacks.add(gun);
                }
            }
        });
    }

    private void dividedGuns() {
        int size = this.allowGunStacks.size();
        if (size >= 60) {
            this.extraAllowGunStacks = this.allowGunStacks.subList(60, size);
            this.allowGunStacks = this.allowGunStacks.subList(0, 60);
        }
    }
}

