/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.resource;

import cn.sh1rocu.tacz.api.event.AddReloadListenerEvent;
import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.tacz.guns.api.vmlib.LuaGunLogicConstant;
import com.tacz.guns.api.vmlib.LuaLibrary;
import com.tacz.guns.crafting.GunSmithTableIngredient;
import com.tacz.guns.crafting.GunSmithTableRecipe;
import com.tacz.guns.crafting.result.GunSmithTableResult;
import com.tacz.guns.init.ModRecipe;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.ServerMessageSyncGunPack;
import com.tacz.guns.resource.ICommonResourceProvider;
import com.tacz.guns.resource.filter.RecipeFilter;
import com.tacz.guns.resource.index.CommonAmmoIndex;
import com.tacz.guns.resource.index.CommonAttachmentIndex;
import com.tacz.guns.resource.index.CommonBlockIndex;
import com.tacz.guns.resource.index.CommonGunIndex;
import com.tacz.guns.resource.manager.AttachmentDataManager;
import com.tacz.guns.resource.manager.AttachmentsTagManager;
import com.tacz.guns.resource.manager.CommonDataManager;
import com.tacz.guns.resource.manager.INetworkCacheReloadListener;
import com.tacz.guns.resource.manager.RecipeFilterManager;
import com.tacz.guns.resource.manager.ScriptManager;
import com.tacz.guns.resource.network.CommonNetworkCache;
import com.tacz.guns.resource.network.DataType;
import com.tacz.guns.resource.pojo.data.attachment.AttachmentData;
import com.tacz.guns.resource.pojo.data.block.BlockData;
import com.tacz.guns.resource.pojo.data.block.TabConfig;
import com.tacz.guns.resource.pojo.data.gun.ExtraDamage;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.resource.pojo.data.gun.Ignite;
import com.tacz.guns.resource.serialize.CommonAmmoIndexSerializer;
import com.tacz.guns.resource.serialize.CommonAttachmentIndexSerializer;
import com.tacz.guns.resource.serialize.CommonBlockIndexSerializer;
import com.tacz.guns.resource.serialize.CommonGunIndexSerializer;
import com.tacz.guns.resource.serialize.DistanceDamagePairSerializer;
import com.tacz.guns.resource.serialize.GunSmithTableIngredientSerializer;
import com.tacz.guns.resource.serialize.GunSmithTableResultSerializer;
import com.tacz.guns.resource.serialize.IgniteSerializer;
import com.tacz.guns.resource.serialize.PairSerializer;
import com.tacz.guns.resource.serialize.Vec3Serializer;
import com.tacz.guns.util.AllowAttachmentTagMatcher;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import net.minecraft.class_1863;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3283;
import net.minecraft.class_3302;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7654;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.Nullable;
import org.luaj.vm2.LuaTable;

public class CommonAssetsManager
implements ICommonResourceProvider {
    private static CommonAssetsManager INSTANCE;
    public static final Gson GSON;
    private final List<INetworkCacheReloadListener> listeners = new ArrayList<INetworkCacheReloadListener>();
    private CommonDataManager<GunData> gunData;
    private CommonDataManager<AttachmentData> attachmentData;
    private CommonDataManager<BlockData> blockData;
    private CommonDataManager<CommonAmmoIndex> ammoIndex;
    private CommonDataManager<CommonGunIndex> gunIndex;
    private CommonDataManager<CommonAttachmentIndex> attachmentIndex;
    private CommonDataManager<CommonBlockIndex> blockIndex;
    private RecipeFilterManager recipeFilterManager;
    private AttachmentsTagManager attachmentsTagManager;
    List<LuaLibrary> libList = List.of(new LuaGunLogicConstant());
    private final ScriptManager scriptManager = new ScriptManager(new class_7654("scripts", ".lua"), this.libList);
    public class_1863 recipeManager;

    public void reloadAndRegister(Consumer<class_3302> register) {
        this.gunData = this.register(new CommonDataManager<GunData>(DataType.GUN_DATA, GunData.class, GSON, "data/guns", "GunDataLoader"));
        this.attachmentData = this.register(new AttachmentDataManager());
        this.attachmentsTagManager = this.register(new AttachmentsTagManager());
        this.recipeFilterManager = this.register(new RecipeFilterManager());
        this.blockData = this.register(new CommonDataManager<BlockData>(DataType.BLOCK_DATA, BlockData.class, GSON, "data/blocks", "BlockDataLoader"));
        register.accept((class_3302)this.scriptManager);
        this.ammoIndex = this.register(new CommonDataManager<CommonAmmoIndex>(DataType.AMMO_INDEX, CommonAmmoIndex.class, GSON, "index/ammo", "AmmoIndexLoader"));
        this.gunIndex = this.register(new CommonDataManager<CommonGunIndex>(DataType.GUN_INDEX, CommonGunIndex.class, GSON, "index/guns", "GunIndexLoader"));
        this.attachmentIndex = this.register(new CommonDataManager<CommonAttachmentIndex>(DataType.ATTACHMENT_INDEX, CommonAttachmentIndex.class, GSON, "index/attachments", "AttachmentIndexLoader"));
        this.blockIndex = this.register(new CommonDataManager<CommonBlockIndex>(DataType.BLOCK_INDEX, CommonBlockIndex.class, GSON, "index/blocks", "BlockIndexLoader"));
        this.listeners.forEach(register);
        register.accept((barrier, resourceManager, preparationProfiler, reloadProfiler, backgroundExecutor, gameExecutor) -> barrier.method_18352(Void.TYPE).thenRunAsync(AllowAttachmentTagMatcher::resetCache, gameExecutor));
    }

    private <T extends INetworkCacheReloadListener> T register(T listener) {
        this.listeners.add(listener);
        return listener;
    }

    public Map<DataType, Map<class_2960, String>> getNetworkCache() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (INetworkCacheReloadListener listener : this.listeners) {
            builder.put((Object)listener.getType(), listener.getNetworkCache());
        }
        return builder.build();
    }

    @Override
    @Nullable
    public GunData getGunData(class_2960 id) {
        return (GunData)this.gunData.getData(id);
    }

    @Override
    @Nullable
    public AttachmentData getAttachmentData(class_2960 id) {
        return (AttachmentData)this.attachmentData.getData(id);
    }

    @Override
    @Nullable
    public BlockData getBlockData(class_2960 id) {
        return (BlockData)this.blockData.getData(id);
    }

    @Override
    @Nullable
    public RecipeFilter getRecipeFilter(class_2960 id) {
        return this.recipeFilterManager.getFilter(id);
    }

    @Override
    @Nullable
    public CommonGunIndex getGunIndex(class_2960 gunId) {
        return (CommonGunIndex)this.gunIndex.getData(gunId);
    }

    @Override
    public Set<Map.Entry<class_2960, CommonGunIndex>> getAllGuns() {
        return this.gunIndex.getAllData().entrySet();
    }

    @Override
    @Nullable
    public CommonAmmoIndex getAmmoIndex(class_2960 ammoId) {
        return (CommonAmmoIndex)this.ammoIndex.getData(ammoId);
    }

    @Override
    public Set<Map.Entry<class_2960, CommonAmmoIndex>> getAllAmmos() {
        return this.ammoIndex.getAllData().entrySet();
    }

    @Override
    @Nullable
    public CommonAttachmentIndex getAttachmentIndex(class_2960 attachmentId) {
        return (CommonAttachmentIndex)this.attachmentIndex.getData(attachmentId);
    }

    @Override
    public Set<Map.Entry<class_2960, CommonAttachmentIndex>> getAllAttachments() {
        return this.attachmentIndex.getAllData().entrySet();
    }

    @Override
    public LuaTable getScript(class_2960 scriptId) {
        return this.scriptManager.getScript(scriptId);
    }

    @Override
    @Nullable
    public CommonBlockIndex getBlockIndex(class_2960 blockId) {
        return (CommonBlockIndex)this.blockIndex.getData(blockId);
    }

    @Override
    public Set<Map.Entry<class_2960, CommonBlockIndex>> getAllBlocks() {
        return this.blockIndex.getAllData().entrySet();
    }

    @Override
    public Set<String> getAttachmentTags(class_2960 registryName) {
        return this.attachmentsTagManager.getAttachmentTags(registryName);
    }

    @Override
    public Set<String> getAllowAttachmentTags(class_2960 registryName) {
        return this.attachmentsTagManager.getAllowAttachmentTags(registryName);
    }

    @Nullable
    public static CommonAssetsManager getInstance() {
        return INSTANCE;
    }

    public static ICommonResourceProvider get() {
        return INSTANCE == null ? CommonNetworkCache.INSTANCE : INSTANCE;
    }

    public static void onReload(AddReloadListenerEvent event) {
        CommonAssetsManager commonAssetsManager = new CommonAssetsManager();
        commonAssetsManager.reloadAndRegister(event::addListener);
        INSTANCE = commonAssetsManager;
        CommonAssetsManager.INSTANCE.recipeManager = event.getServerResources().method_29471();
    }

    public static void onReload(class_5455 registries, boolean client) {
        if (!client && CommonAssetsManager.getInstance() != null && CommonAssetsManager.getInstance().recipeManager != null) {
            List recipes = CommonAssetsManager.getInstance().recipeManager.method_30027(ModRecipe.GUN_SMITH_TABLE_CRAFTING);
            for (class_8786 recipe : recipes) {
                ((GunSmithTableRecipe)recipe.comp_1933()).init((class_7225.class_7874)registries);
            }
        }
    }

    public static void onServerStopped(MinecraftServer server) {
        INSTANCE = null;
    }

    public static void OnDatapackSync(class_3222 player, boolean joined) {
        if (CommonAssetsManager.getInstance() == null) {
            return;
        }
        ServerMessageSyncGunPack message = new ServerMessageSyncGunPack(CommonAssetsManager.getInstance().getNetworkCache());
        NetworkHandler.sendToClientPlayer(message, player);
    }

    public static void reloadAllPack(MinecraftServer server) {
        if (server == null) {
            return;
        }
        class_3283 packrepository = server.method_3836();
        packrepository.method_14445();
        Collection collection = packrepository.method_29210();
        server.method_29439(collection);
    }

    static {
        GSON = new GsonBuilder().registerTypeAdapter(class_2960.class, (Object)new class_2960.class_2961()).registerTypeAdapter(Pair.class, (Object)new PairSerializer()).registerTypeAdapter(GunSmithTableIngredient.class, (Object)new GunSmithTableIngredientSerializer()).registerTypeAdapter(GunSmithTableResult.class, (Object)new GunSmithTableResultSerializer()).registerTypeAdapter(ExtraDamage.DistanceDamagePair.class, (Object)new DistanceDamagePairSerializer()).registerTypeAdapter(class_243.class, (Object)new Vec3Serializer()).registerTypeAdapter(Ignite.class, (Object)new IgniteSerializer()).registerTypeAdapter(RecipeFilter.class, (Object)new RecipeFilter.Deserializer()).registerTypeAdapter(CommonGunIndex.class, (Object)new CommonGunIndexSerializer()).registerTypeAdapter(CommonAmmoIndex.class, (Object)new CommonAmmoIndexSerializer()).registerTypeAdapter(CommonAttachmentIndex.class, (Object)new CommonAttachmentIndexSerializer()).registerTypeAdapter(CommonBlockIndex.class, (Object)new CommonBlockIndexSerializer()).registerTypeAdapter(TabConfig.class, (Object)new TabConfig.Deserializer()).create();
    }
}

