/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.util;

import com.tacz.guns.resource.CommonAssetsManager;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.class_2960;
import org.apache.commons.lang3.tuple.Pair;

public final class AllowAttachmentTagMatcher {
    private static final String TAG_PREFIX = "#";
    private static final Cache CACHE = new Cache();

    public static boolean match(class_2960 gunId, class_2960 attachmentId) {
        Pair key = Pair.of((Object)gunId, (Object)attachmentId);
        return CACHE.allowAttachmentCache().computeIfAbsent((Pair<class_2960, class_2960>)key, AllowAttachmentTagMatcher::match0);
    }

    public static boolean match0(Pair<class_2960, class_2960> record) {
        class_2960 gunId = (class_2960)record.getLeft();
        class_2960 attachmentId = (class_2960)record.getRight();
        Set<String> allowAttachmentTags = CommonAssetsManager.get().getAllowAttachmentTags(gunId);
        if (allowAttachmentTags == null || allowAttachmentTags.isEmpty()) {
            return false;
        }
        AtomicBoolean searchSignal = new AtomicBoolean(false);
        AllowAttachmentTagMatcher.treeSearch(allowAttachmentTags, attachmentId, searchSignal);
        return searchSignal.get();
    }

    public static boolean matchTag(class_2960 tag, class_2960 attachmentId) {
        Pair key = Pair.of((Object)tag, (Object)attachmentId);
        return CACHE.tagMatchCache().computeIfAbsent((Pair<class_2960, class_2960>)key, AllowAttachmentTagMatcher::matchTag0);
    }

    public static boolean matchTag0(Pair<class_2960, class_2960> record) {
        class_2960 tag = (class_2960)record.getLeft();
        class_2960 attachmentId = (class_2960)record.getRight();
        Set<String> tagContent = CommonAssetsManager.get().getAttachmentTags(tag);
        if (tagContent == null || tagContent.isEmpty()) {
            return false;
        }
        AtomicBoolean searchSignal = new AtomicBoolean(false);
        AllowAttachmentTagMatcher.treeSearch(tagContent, attachmentId, searchSignal);
        return searchSignal.get();
    }

    private static void treeSearch(Set<String> tags, class_2960 attachmentId, AtomicBoolean searchSignal) {
        for (String tag : tags) {
            if (tag.startsWith(TAG_PREFIX)) {
                class_2960 tagId = class_2960.method_60654((String)tag.substring(TAG_PREFIX.length()));
                Set<String> attachmentTags = CommonAssetsManager.get().getAttachmentTags(tagId);
                if (attachmentTags == null || attachmentTags.isEmpty()) continue;
                AllowAttachmentTagMatcher.treeSearch(attachmentTags, attachmentId, searchSignal);
                continue;
            }
            class_2960 matchAttachmentId = class_2960.method_60654((String)tag);
            if (!attachmentId.equals((Object)matchAttachmentId)) continue;
            searchSignal.set(true);
            return;
        }
    }

    public static void resetCache() {
        CACHE.allowAttachmentCache().clear();
        CACHE.tagMatchCache().clear();
    }

    public record Cache(Map<Pair<class_2960, class_2960>, Boolean> allowAttachmentCache, Map<Pair<class_2960, class_2960>, Boolean> tagMatchCache) {
        public Cache() {
            this(new ConcurrentHashMap<Pair<class_2960, class_2960>, Boolean>(), new ConcurrentHashMap<Pair<class_2960, class_2960>, Boolean>());
        }
    }
}

