/*
 * Decompiled with CFR 0.152.
 */
package com.tacz.guns.entity.shooter;

import cn.sh1rocu.tacz.api.LogicalSide;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.entity.ReloadState;
import com.tacz.guns.api.event.common.GunReloadEvent;
import com.tacz.guns.api.item.gun.AbstractGunItem;
import com.tacz.guns.entity.shooter.LivingEntityDrawGun;
import com.tacz.guns.entity.shooter.LivingEntityShoot;
import com.tacz.guns.entity.shooter.ShooterDataHolder;
import com.tacz.guns.network.NetworkHandler;
import com.tacz.guns.network.message.event.ServerMessageGunReload;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class LivingEntityReload {
    private final class_1309 shooter;
    private final ShooterDataHolder data;
    private final LivingEntityDrawGun draw;
    private final LivingEntityShoot shoot;

    public LivingEntityReload(class_1309 shooter, ShooterDataHolder data, LivingEntityDrawGun draw, LivingEntityShoot shoot) {
        this.shooter = shooter;
        this.data = data;
        this.draw = draw;
        this.shoot = shoot;
    }

    public void reload() {
        if (this.data.currentGunItem == null) {
            return;
        }
        class_1799 currentGunItem = this.data.currentGunItem.get();
        class_1792 class_17922 = currentGunItem.method_7909();
        if (!(class_17922 instanceof AbstractGunItem)) {
            return;
        }
        AbstractGunItem gunItem = (AbstractGunItem)class_17922;
        class_2960 gunId = gunItem.getGunId(currentGunItem);
        TimelessAPI.getCommonGunIndex(gunId).ifPresent(gunIndex -> {
            if (gunItem.useInventoryAmmo(currentGunItem)) {
                return;
            }
            if (this.data.reloadStateType.isReloading()) {
                return;
            }
            if (this.shoot.getShootCoolDown() != 0L) {
                return;
            }
            if (this.draw.getDrawCoolDown() != 0L) {
                return;
            }
            if (this.data.isBolting) {
                return;
            }
            if (IGunOperator.fromLivingEntity(this.shooter).needCheckAmmo() && !gunItem.canReload(this.shooter, currentGunItem)) {
                return;
            }
            GunReloadEvent gunReloadEvent = new GunReloadEvent(this.shooter, currentGunItem, LogicalSide.SERVER);
            ((GunReloadEvent.Callback)GunReloadEvent.CALLBACK.invoker()).post(gunReloadEvent);
            if (gunReloadEvent.isCanceled()) {
                return;
            }
            NetworkHandler.sendToTrackingEntity(new ServerMessageGunReload(this.shooter.method_5628(), currentGunItem), (class_1297)this.shooter);
            Bolt boltType = gunIndex.getGunData().getBolt();
            int ammoCount = gunItem.getCurrentAmmoCount(currentGunItem) + (gunItem.hasBulletInBarrel(currentGunItem) && boltType != Bolt.OPEN_BOLT ? 1 : 0);
            this.data.reloadStateType = ammoCount <= 0 ? ReloadState.StateType.EMPTY_RELOAD_FEEDING : ReloadState.StateType.TACTICAL_RELOAD_FEEDING;
            this.data.reloadTimestamp = System.currentTimeMillis();
            if (!gunItem.startReload(this.data, currentGunItem, this.shooter)) {
                this.data.reloadStateType = ReloadState.StateType.NOT_RELOADING;
                this.data.reloadTimestamp = -1L;
            }
        });
    }

    public void cancelReload() {
        if (this.data.currentGunItem == null) {
            return;
        }
        class_1799 currentGunItem = this.data.currentGunItem.get();
        class_1792 class_17922 = currentGunItem.method_7909();
        if (!(class_17922 instanceof AbstractGunItem)) {
            return;
        }
        AbstractGunItem gunItem = (AbstractGunItem)class_17922;
        if (!this.data.reloadStateType.isReloading()) {
            return;
        }
        gunItem.interruptReload(this.data, currentGunItem, this.shooter);
    }

    public ReloadState tickReloadState() {
        class_1792 class_17922;
        class_1799 currentGunItem;
        ReloadState result = new ReloadState();
        if (this.data.reloadTimestamp == -1L) {
            return result;
        }
        if (this.data.currentGunItem != null && (currentGunItem = this.data.currentGunItem.get()) != null && (class_17922 = currentGunItem.method_7909()) instanceof AbstractGunItem) {
            AbstractGunItem abstractGunItem = (AbstractGunItem)class_17922;
            result = abstractGunItem.tickReload(this.data, currentGunItem, this.shooter);
        }
        this.data.reloadStateType = result.getStateType();
        if (!result.getStateType().isReloading()) {
            this.data.reloadTimestamp = -1L;
        }
        return result;
    }
}

