package com.tacz.guns.api.modifier;

import com.google.common.collect.Lists;
import javax.annotation.Nullable;
import net.minecraft.class_2561;
import java.util.List;

/**
 * 配件从 Json 读取的数据
 *
 * @param <T> Json 读取后转换成的中间数据类型
 */
public abstract class JsonProperty<T> {
    protected List<class_2561> components = Lists.newArrayList();
    private @Nullable T value;

    public JsonProperty(@Nullable T value) {
        this.value = value;
    }

    @Nullable
    public T getValue() {
        return value;
    }

    public void setValue(@Nullable T value) {
        this.value = value;
    }

    public List<class_2561> getComponents() {
        return components;
    }

    /**
     * 初始化文本提示，用于配件的描述文本
     */
    public abstract void initComponents();
}
