package com.tacz.guns.client.gui;

import cn.sh1rocu.tacz.mixin.accessor.ScreenAccessor;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.client.animation.screen.RefitTransform;
import com.tacz.guns.client.gui.components.FlatColorButton;
import com.tacz.guns.client.gui.components.refit.*;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientAttachmentIndex;
import com.tacz.guns.client.sound.SoundPlayManager;
import com.tacz.guns.network.message.ClientMessageLaserColor;
import com.tacz.guns.network.message.ClientMessageRefitGun;
import com.tacz.guns.network.message.ClientMessageUnloadAttachment;
import com.tacz.guns.sound.SoundManager;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.client.screen.v1.Screens;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_437;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;

@Environment(EnvType.CLIENT)
public class GunRefitScreen extends class_437 {
    public static final class_2960 SLOT_TEXTURE = class_2960.method_60655(GunMod.MOD_ID, "textures/gui/refit_slot.png");
    public static final class_2960 TURN_PAGE_TEXTURE = class_2960.method_60655(GunMod.MOD_ID, "textures/gui/refit_turn_page.png");
    public static final class_2960 UNLOAD_TEXTURE = class_2960.method_60655(GunMod.MOD_ID, "textures/gui/refit_unload.png");
    public static final class_2960 ICONS_TEXTURE = class_2960.method_60655(GunMod.MOD_ID, "textures/gui/refit_slot_icons.png");

    public static final int ICON_UV_SIZE = 32;
    public static final int SLOT_SIZE = 18;
    private static final int INVENTORY_ATTACHMENT_SLOT_COUNT = 8;
    private static boolean HIDE_GUN_PROPERTY_DIAGRAMS = true;

    private int currentPage = 0;

    public GunRefitScreen() {
        super(class_2561.method_43470("Gun Refit Screen"));
        RefitTransform.init();
    }

    public static int getSlotTextureXOffset(class_1799 gunItem, AttachmentType attachmentType) {
        IGun iGun = IGun.getIGunOrNull(gunItem);
        if (iGun == null) {
            return -1;
        }
        if (!iGun.allowAttachmentType(gunItem, attachmentType)) {
            return ICON_UV_SIZE * 6;
        }
        switch (attachmentType) {
            case GRIP -> {
                return 0;
            }
            case LASER -> {
                return ICON_UV_SIZE;
            }
            case MUZZLE -> {
                return ICON_UV_SIZE * 2;
            }
            case SCOPE -> {
                return ICON_UV_SIZE * 3;
            }
            case STOCK -> {
                return ICON_UV_SIZE * 4;
            }
            case EXTENDED_MAG -> {
                return ICON_UV_SIZE * 5;
            }
        }
        return -1;
    }

    public static int getSlotsTextureWidth() {
        return ICON_UV_SIZE * 7;
    }

    @Override
    public void method_25426() {
        this.method_37067();
        // 添加配件槽位
        this.addAttachmentTypeButtons();
        // 添加可选配件列表
        this.addInventoryAttachmentButtons();
        // 添加属性图隐藏按钮
        if (HIDE_GUN_PROPERTY_DIAGRAMS) {
            this.method_37063(new FlatColorButton(11, 11, 288, 16,
                    class_2561.method_43471("gui.tacz.gun_refit.property_diagrams.show"), b -> switchHideButton()));
        } else {
            this.method_37063(new FlatColorButton(14, 14, 12, 12, class_2561.method_43470("S"), b -> {
                class_746 player = class_310.method_1551().field_1724;
                if (player == null || player.method_7325()) return;
                if (IGun.mainHandHoldGun(player)) {
                    IClientPlayerGunOperator.fromLocalPlayer(player).fireSelect();
                    this.method_25426();
                }
            }).setTooltips(class_2561.method_43471("gui.tacz.gun_refit.property_diagrams.fire_mode.switch")));
            int buttonYOffset = GunPropertyDiagrams.getHidePropertyButtonYOffset();
            this.method_37063(new FlatColorButton(11, buttonYOffset, 288, 12,
                    class_2561.method_43471("gui.tacz.gun_refit.property_diagrams.hide"), b -> switchHideButton()));
        }
    }

    @Override
    protected void method_57734(float partialTick) {

    }

    @Override
    public void method_25394(@NotNull class_332 graphics, int mouseX, int mouseY, float pPartialTick) {
        super.method_25394(graphics, mouseX, mouseY, pPartialTick);

        if (!HIDE_GUN_PROPERTY_DIAGRAMS) {
            GunPropertyDiagrams.draw(graphics, field_22793, 11, 11);
        }

        ((ScreenAccessor) this).tacz$getRenderables().stream().filter(w -> w instanceof IComponentTooltip).forEach(w -> ((IComponentTooltip) w)
                .renderTooltip(component -> graphics.method_51434(field_22793, component, mouseX, mouseY)));
        ((ScreenAccessor) this).tacz$getRenderables().stream().filter(w -> w instanceof IStackTooltip).forEach(w -> ((IStackTooltip) w)
                .renderTooltip(stack -> graphics.method_51446(field_22793, stack, mouseX, mouseY)));
    }

    @Override
    public boolean method_25421() {
        return false;
    }

    private void addInventoryAttachmentButtons() {
        class_746 player = Screens.getClient(this).field_1724;
        if (RefitTransform.getCurrentTransformType() == AttachmentType.NONE || player == null) {
            return;
        }
        int startX = this.field_22789 - 30;
        int startY = 50;
        int pageStart = currentPage * INVENTORY_ATTACHMENT_SLOT_COUNT;
        int count = 0;
        int currentY = startY;
        class_1661 inventory = player.method_31548();
        for (int i = 0; i < inventory.method_5439(); i++) {
            class_1799 inventoryItem = inventory.method_5438(i);
            IAttachment attachment = IAttachment.getIAttachmentOrNull(inventoryItem);
            IGun iGun = IGun.getIGunOrNull(player.method_6047());
            if (attachment != null && iGun != null && attachment.getType(inventoryItem) == RefitTransform.getCurrentTransformType()) {
                if (!iGun.allowAttachment(player.method_6047(), inventoryItem)) {
                    continue;
                }
                count++;
                if (count <= pageStart) {
                    continue;
                }
                if (count > pageStart + INVENTORY_ATTACHMENT_SLOT_COUNT) {
                    continue;
                }
                InventoryAttachmentSlot button = new InventoryAttachmentSlot(startX, currentY, i, inventory, b -> {
                    int slotIndex = ((InventoryAttachmentSlot) b).getSlotIndex();
                    SoundPlayManager.playerRefitSound(inventory.method_5438(slotIndex), player, SoundManager.INSTALL_SOUND);
                    ClientMessageRefitGun message = new ClientMessageRefitGun(slotIndex, inventory.field_7545, RefitTransform.getCurrentTransformType());
                    ClientPlayNetworking.send(message);
                });
                this.method_37063(button);
                currentY = currentY + SLOT_SIZE;
            }
        }
        int totalPage = (count - 1) / INVENTORY_ATTACHMENT_SLOT_COUNT;
        RefitTurnPageButton turnPageButtonUp = new RefitTurnPageButton(startX, startY - 10, true, b -> {
            if (currentPage > 0) {
                currentPage--;
                method_25426();
            }
        });
        RefitTurnPageButton turnPageButtonDown = new RefitTurnPageButton(startX, startY + SLOT_SIZE * INVENTORY_ATTACHMENT_SLOT_COUNT + 2, false, b -> {
            if (currentPage < totalPage) {
                currentPage++;
                method_25426();
            }
        });
        if (currentPage < totalPage) {
            this.method_37063(turnPageButtonDown);
        }
        if (currentPage > 0) {
            this.method_37063(turnPageButtonUp);
        }
    }

    private void addAttachmentTypeButtons() {
        class_746 player = Screens.getClient(this).field_1724;
        if (player == null) {
            return;
        }
        IGun iGun = IGun.getIGunOrNull(player.method_6047());
        if (iGun == null) {
            return;
        }
        int startX = this.field_22789 - 30;
        int startY = 10;
        class_1661 inventory = player.method_31548();
        for (AttachmentType type : AttachmentType.values()) {
            if (type == AttachmentType.NONE) {
                if (RefitTransform.getCurrentTransformType() == AttachmentType.NONE) {
                    TimelessAPI.getGunDisplay(player.method_6047())
                            .map(GunDisplayInstance::getLaserConfig)
                            .ifPresent(laserConfig -> {
                                if (laserConfig.canEdit()) {
                                    // 添加镭射颜色选择器
                                    HSVSliderGroup hsvSliderGroup = new HSVSliderGroup(field_22789 - 140, field_22790 - 64, 120, 16, inventory, inventory.field_7545, AttachmentType.NONE);
                                    this.method_37063(hsvSliderGroup.getHueSlider());
                                    this.method_37063(hsvSliderGroup.getSaturationSlider());
                                }
                            });
                }
                continue;
            }
            GunAttachmentSlot button = new GunAttachmentSlot(startX, startY, type, inventory.field_7545, inventory, b -> {
                AttachmentType buttonType = ((GunAttachmentSlot) b).getType();
                // 如果这个槽位不允许安装配件，则默认退回概览，不选中槽位。
                if (!((GunAttachmentSlot) b).isAllow()) {
                    if (RefitTransform.changeRefitScreenView(AttachmentType.NONE)) {
                        this.method_25426();
                    }
                    return;
                }
                // 点击的是当前选中的槽位，则退回概览
                if (RefitTransform.getCurrentTransformType() == buttonType && buttonType != AttachmentType.NONE) {
                    if (RefitTransform.changeRefitScreenView(AttachmentType.NONE)) {
                        this.method_25426();
                    }
                    return;
                }
                // 切换选中的槽位。
                if (RefitTransform.changeRefitScreenView(buttonType)) {
                    this.method_25426();
                }
            });
            if (RefitTransform.getCurrentTransformType() == type) {
                button.setSelected(true);
                // 添加拆卸配件按钮
                RefitUnloadButton unloadButton = new RefitUnloadButton(startX + 5, startY + SLOT_SIZE + 2, b -> {
                    class_1799 attachmentItem = button.getAttachmentItem();
                    if (!attachmentItem.method_7960()) {
                        int freeSlot = inventory.method_7376();
                        if (freeSlot != -1) {
                            SoundPlayManager.playerRefitSound(attachmentItem, player, SoundManager.UNINSTALL_SOUND);
                            ClientMessageUnloadAttachment message = new ClientMessageUnloadAttachment(inventory.field_7545, RefitTransform.getCurrentTransformType());
                            ClientPlayNetworking.send(message);
                        } else {
                            player.method_43496(class_2561.method_43471("gui.tacz.gun_refit.unload.no_space"));
                        }
                    }
                });
                if (!button.getAttachmentItem().method_7960()) {
                    this.method_37063(unloadButton);

                    if (button.getAttachmentItem().method_7909() instanceof IAttachment iAttachment) {
                        TimelessAPI.getClientAttachmentIndex(iAttachment.getAttachmentId(button.getAttachmentItem()))
                                .map(ClientAttachmentIndex::getLaserConfig)
                                .ifPresent(laserConfig -> {
                                    if (laserConfig.canEdit()) {
                                        // 添加镭射颜色选择器
                                        HSVSliderGroup hsvSliderGroup = new HSVSliderGroup(field_22789 - 140, field_22790 - 64, 120, 16, inventory, inventory.field_7545, type);
                                        this.method_37063(hsvSliderGroup.getHueSlider());
                                        this.method_37063(hsvSliderGroup.getSaturationSlider());
                                    }
                                });
                    }
                }
            }
            this.method_37063(button);
            startX = startX - SLOT_SIZE;
        }
    }

    @Override
    public void method_25419() {
        // 关闭界面时，一次性上传所有的染色数据
        class_746 player = Screens.getClient(this).field_1724;
        if (player != null) {
            class_1799 gun = player.method_6047();
            if (player.method_6047().method_7909() instanceof IGun) {
                ClientMessageLaserColor message = new ClientMessageLaserColor(gun, player.method_31548().field_7545);
                ClientPlayNetworking.send(message);
            }
        }
        super.method_25419();
    }

    private void switchHideButton() {
        HIDE_GUN_PROPERTY_DIAGRAMS = !HIDE_GUN_PROPERTY_DIAGRAMS;
        this.method_25426();
    }
}
