package com.tacz.guns.client.gui.components.refit;

import cn.sh1rocu.tacz.util.forge.ExtendedSlider;
import com.tacz.guns.api.item.IAttachment;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.attachment.AttachmentType;
import com.tacz.guns.util.LaserColorUtil;
import org.jetbrains.annotations.NotNull;

import java.awt.*;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_310;

public class HSVSliderGroup {
    private final class_1661 inventory;
    private final int gunItemIndex;

    private final AttachmentType type;

    private final LaserColorSlider hueSlider;
    private final LaserColorSlider saturationSlider;

    public HSVSliderGroup(int x, int y, int width, int height, class_1661 inventory, int gunItemIndex, @NotNull AttachmentType type) {
        this.inventory = inventory;
        this.gunItemIndex = gunItemIndex;
        this.type = type;

        int color = getColor(type);
        float[] hsb = Color.RGBtoHSB((color >> 16) & 0xFF, (color >> 8) & 0xFF, color & 0xFF, null);

        hueSlider = new LaserColorSlider(x, y, width, height, this, hsb[0]);
        saturationSlider = new LaserColorSlider(x, y + 2 + height, width, height, this, hsb[1]);
    }

    public LaserColorSlider getHueSlider() {
        return hueSlider;
    }

    public LaserColorSlider getSaturationSlider() {
        return saturationSlider;
    }


    public void apply() {
        // 需要检查的实现
        // 这里写往客户端写nbt其实是脏写，只为了确保能实时预览染色效果
        // 需要在合适的时机向服务器发包通知改动
        // 不在此直接向服务器发包是因为这个组件在滑动时会被非常频繁的调用，不希望频繁向服务器发包
        class_1799 gun = inventory.method_5438(gunItemIndex);
        if (gun.method_7909() instanceof IGun iGun) {
            int rgb_new = Color.HSBtoRGB((float) hueSlider.getValue(), (float) saturationSlider.getValue(), 1f);

            if (type == AttachmentType.NONE) {
                iGun.setLaserColor(gun, rgb_new);
                return;
            }

            class_1799 laser = iGun.getAttachment(class_310.method_1551().field_1687.method_30349(), gun, type);
            if (laser.method_7909() instanceof IAttachment iAttachment) {
                iAttachment.setLaserColor(laser, rgb_new);
            }
        }
    }


    private int getColor(AttachmentType type) {
        if (inventory == null) {
            return 0XFF0000;
        }
        class_1799 gun = inventory.method_5438(gunItemIndex);

        if (gun.method_7909() instanceof IGun iGun) {
            if (type == AttachmentType.NONE) {
                return LaserColorUtil.getLaserColor(gun);
            } else {
                class_1799 attachment = iGun.getAttachment(class_310.method_1551().field_1687.method_30349(), gun, type);
                return LaserColorUtil.getLaserColor(attachment);
            }
        }

        return 0XFF0000;
    }

    public static class LaserColorSlider extends ExtendedSlider {
        private final HSVSliderGroup parent;

        public LaserColorSlider(int x, int y, int width, int height, HSVSliderGroup parent, double current) {
            super(x, y, width, height, class_2561.method_43473(), class_2561.method_43473(), 0, 1, current, 0.01, 0, true);
            this.parent = parent;
        }

        @Override
        protected void method_25344() {
            parent.apply();
        }
    }
}
