package com.tacz.guns.client.gui.overlay;

import com.mojang.blaze3d.systems.RenderSystem;
import com.tacz.guns.GunMod;
import com.tacz.guns.api.TimelessAPI;
import com.tacz.guns.api.client.gameplay.IClientPlayerGunOperator;
import com.tacz.guns.api.entity.IGunOperator;
import com.tacz.guns.api.item.IAmmo;
import com.tacz.guns.api.item.IAmmoBox;
import com.tacz.guns.api.item.IGun;
import com.tacz.guns.api.item.gun.FireMode;
import com.tacz.guns.client.resource.GunDisplayInstance;
import com.tacz.guns.client.resource.index.ClientGunIndex;
import com.tacz.guns.client.resource.pojo.display.gun.AmmoCountStyle;
import com.tacz.guns.config.client.RenderConfig;
import com.tacz.guns.resource.pojo.data.gun.Bolt;
import com.tacz.guns.resource.pojo.data.gun.GunData;
import com.tacz.guns.util.AttachmentDataUtils;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_155;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_746;
import net.minecraft.class_757;
import net.minecraft.class_9779;
import org.jetbrains.annotations.Nullable;

import java.text.DecimalFormat;

public class GunHudOverlay {
    private static final class_2960 SEMI = class_2960.method_60655(GunMod.MOD_ID, "textures/hud/fire_mode_semi.png");
    private static final class_2960 AUTO = class_2960.method_60655(GunMod.MOD_ID, "textures/hud/fire_mode_auto.png");
    private static final class_2960 BURST = class_2960.method_60655(GunMod.MOD_ID, "textures/hud/fire_mode_burst.png");
    private static final class_2960 HEATBAR = class_2960.method_60655(GunMod.MOD_ID, "textures/hud/heat_bar.png");
    private static final class_2960 HEATBASE = class_2960.method_60655(GunMod.MOD_ID, "textures/hud/heat_base.png");

    private static final DecimalFormat CURRENT_AMMO_FORMAT = new DecimalFormat("000");
    private static final DecimalFormat CURRENT_AMMO_FORMAT_PERCENT = new DecimalFormat("000%");
    private static final DecimalFormat INVENTORY_AMMO_FORMAT = new DecimalFormat("0000");
    private static long checkAmmoTimestamp = -1L;
    private static int cacheMaxAmmoCount = 0;
    private static int cacheInventoryAmmoCount = 0;

    private static final int MAX_AMMO_COUNT = 9999;

    public static void render(class_332 graphics, class_9779 deltaTracker) {
        int width = graphics.method_51421();
        int height = graphics.method_51443();

        if (!RenderConfig.GUN_HUD_ENABLE.get()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        class_746 player = mc.field_1724;
        if (!(player instanceof IClientPlayerGunOperator)) {
            return;
        }
        class_1799 stack = player.method_6047();
        if (!(stack.method_7909() instanceof IGun iGun)) {
            return;
        }
        class_2960 gunId = iGun.getGunId(stack);

        GunData gunData = TimelessAPI.getClientGunIndex(gunId).map(ClientGunIndex::getGunData).orElse(null);
        GunDisplayInstance display = TimelessAPI.getGunDisplay(stack).orElse(null);
        if (gunData == null || display == null) {
            return;
        }

        // 是否背包直读
        boolean useInventoryAmmo = iGun.useInventoryAmmo(stack);
        // 是否使用虚拟备弹
        boolean useDummyAmmo = iGun.useDummyAmmo(stack);
        // 是否完全过热
        boolean overheatLocked = gunData.hasHeatData() && iGun.isOverheatLocked(stack);
        // 当前枪械弹药数
        int ammoCount = useInventoryAmmo ? cacheInventoryAmmoCount + (iGun.hasBulletInBarrel(stack) && gunData.getBolt() != Bolt.OPEN_BOLT ? 1 : 0) :
                iGun.getCurrentAmmoCount(stack) + (iGun.hasBulletInBarrel(stack) && gunData.getBolt() != Bolt.OPEN_BOLT ? 1 : 0);
        ammoCount = Math.min(ammoCount, MAX_AMMO_COUNT);
        // 弹药颜色
        int ammoCountColor;
        if (ammoCount < (cacheMaxAmmoCount * 0.25) && ammoCount < 10 || overheatLocked) {
            // 红色
            ammoCountColor = 0xFF5555;
        } else {
            // 如果背包直读并且使用虚拟备弹为青色，否则背包直读为黄色，其他为白色
            ammoCountColor = useInventoryAmmo && useDummyAmmo ? 0x55FFFF : useInventoryAmmo ? 0xFFFF55 : 0xFFFFFF;
        }
        // 备弹颜色
        int inventoryAmmoCountColor;
        if (!useInventoryAmmo && useDummyAmmo) {
            inventoryAmmoCountColor = 0x55FFFF;
        } else {
            inventoryAmmoCountColor = 0xAAAAAA;
        }

        // 当前枪械弹药数显示
        String currentAmmoCountText;
        if (display.getAmmoCountStyle() == AmmoCountStyle.PERCENT) {
            // 百分比模式
            currentAmmoCountText = CURRENT_AMMO_FORMAT_PERCENT.format((float) ammoCount / (cacheMaxAmmoCount == 0 ? 1f : cacheMaxAmmoCount));
        } else {
            // 普通模式
            currentAmmoCountText = CURRENT_AMMO_FORMAT.format(ammoCount);
        }

        // 备弹数显示 (背包直读模式不显示备弹)
        String inventoryAmmoCountText = useInventoryAmmo ? "" : INVENTORY_AMMO_FORMAT.format(cacheInventoryAmmoCount);
        if (!useInventoryAmmo && gunData.getReloadData().isInfinite()) {
            inventoryAmmoCountText = "∞";
        }

        // 计算弹药数
        handleCacheCount(player, stack, gunData, iGun, useInventoryAmmo);

        // 竖线
        graphics.method_25294(width - 75, height - 43, width - 74, height - 25, 0xFFFFFFFF);

        class_4587 poseStack = graphics.method_51448();

        class_327 font = mc.field_1772;

        // 数字
        poseStack.method_22903();
        poseStack.method_22905(1.5f, 1.5f, 1);
        graphics.method_51433(font, currentAmmoCountText, (int) ((width - 70) / 1.5f), (int) ((height - 43) / 1.5f), ammoCountColor, false);
        poseStack.method_22909();

        poseStack.method_22903();
        poseStack.method_22905(0.8f, 0.8f, 1);
        graphics.method_51433(font, inventoryAmmoCountText, (int) ((width - 68 + mc.field_1772.method_1727(currentAmmoCountText) * 1.5f) / 0.8f), (int) ((height - 43) / 0.8f), inventoryAmmoCountColor, false);
        poseStack.method_22909();

        // 模组版本信息
        String minecraftVersion = class_155.method_16673().method_48019();
        String modVersion = FabricLoader.getInstance().getModContainer(GunMod.MOD_ID).orElseThrow().getMetadata().getVersion().getFriendlyString();
        String debugInfo = String.format("%s-%s", minecraftVersion, modVersion);
        // 文本
        poseStack.method_22903();
        poseStack.method_22905(0.5f, 0.5f, 1);
        graphics.method_25303(font, debugInfo, (int) ((width - 70) / 0.5f), (int) ((height - 29f) / 0.5f), 0xffaaaaaa);
        poseStack.method_22909();

        // 图标渲染
        RenderSystem.enableDepthTest();
        RenderSystem.setShader(class_757::method_34542);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();

        // 获取图标
        class_2960 hudTexture = display.getHUDTexture();
        @Nullable class_2960 hudEmptyTexture = display.getHudEmptyTexture();

        if (ammoCount <= 0 || overheatLocked) {
            if (hudEmptyTexture == null) {
                RenderSystem.setShaderColor(1, 0.3f, 0.3f, 1);
            } else {
                hudTexture = hudEmptyTexture;
            }
        }
        // 渲染枪械图标
        graphics.method_25290(hudTexture, width - 117, height - 44, 0, 0, 39, 13, 39, 13);

        // 渲染开火模式图标
        FireMode fireMode = IGun.getMainHandFireMode(player);
        class_2960 fireModeTexture = switch (fireMode) {
            case AUTO -> AUTO;
            case BURST -> BURST;
            default -> SEMI;
        };
        RenderSystem.setShaderColor(1, 1, 1, 1);
        graphics.method_25290(fireModeTexture, (int) (width - 68.5 + mc.field_1772.method_1727(currentAmmoCountText) * 1.5), height - 38, 0, 0, 10, 10, 10, 10);
    }

    private static void handleCacheCount(class_746 player, class_1799 stack, GunData gunData, IGun iGun, boolean useInventoryAmmo) {
        // 0.05 秒 (1 tick) 检查一次
        if ((System.currentTimeMillis() - checkAmmoTimestamp) > 50) {
            checkAmmoTimestamp = System.currentTimeMillis();
            // 当前枪械的总弹药数
            cacheMaxAmmoCount = AttachmentDataUtils.getAmmoCountWithAttachment(stack, gunData);
            // 玩家背包弹药数
            if (IGunOperator.fromLivingEntity(player).needCheckAmmo()) {
                if (iGun.useDummyAmmo(stack)) {
                    // 缓存虚拟弹药数
                    cacheInventoryAmmoCount = iGun.getDummyAmmoAmount(stack);
                } else {
                    // 缓存背包内的弹药数
                    handleInventoryAmmo(stack, player.method_31548());
                }
            } else {
                cacheInventoryAmmoCount = MAX_AMMO_COUNT;
            }
            if (useInventoryAmmo) {
                iGun.setCurrentAmmoCount(stack, cacheInventoryAmmoCount);
            }
        }
    }

    private static void handleInventoryAmmo(class_1799 stack, class_1661 inventory) {
        cacheInventoryAmmoCount = 0;
        for (int i = 0; i < inventory.method_5439(); i++) {
            class_1799 inventoryItem = inventory.method_5438(i);
            if (inventoryItem.method_7909() instanceof IAmmo iAmmo && iAmmo.isAmmoOfGun(stack, inventoryItem)) {
                cacheInventoryAmmoCount += inventoryItem.method_7947();
            }
            if (inventoryItem.method_7909() instanceof IAmmoBox iAmmoBox && iAmmoBox.isAmmoBoxOfGun(stack, inventoryItem)) {
                // 创造模式弹药箱？直接返回 9999
                if (iAmmoBox.isAllTypeCreative(inventoryItem) || iAmmoBox.isCreative(inventoryItem)) {
                    cacheInventoryAmmoCount = 9999;
                    return;
                }
                cacheInventoryAmmoCount += iAmmoBox.getAmmoCount(inventoryItem);
            }
        }
    }
}
